import QtQuick
import QtQuick.Controls
import Generated.DesignSystem

Button {
    id: bigButton
    width: 169
    height: 60
    property alias startTextText: startText.text
    property alias base: base
    property alias buttonIcon: buttonIcon
    background: Item {}

    Rectangle {
        id: base
        x: 0
        y: 0
        width: 169
        height: 60
        color: Colors.currentTheme.startButtonGreen
        radius: 8
    }

    Rectangle {
        id: bg
        x: 6
        y: 6
        width: 157
        height: 48
        visible: !bigButton.down
        color: Colors.currentTheme.black
        radius: 2
    }

    Image {
        id: buttonIcon
        x: 32
        y: 19
        source: "assets/buttonIcon.png"
    }

    Text {
        id: startText
        x: 82
        y: 0
        width: 88
        height: 60
        color: "#fafafa"
        text: qsTr("START")
        font.pixelSize: 20
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.Wrap
        font.weight: Font.DemiBold
        font.family: "Exo"
    }
}

/*##^##
Designer {
    D{i:0;uuid:"cd40edc1-edd2-52fe-aad0-9abb8d156854"}D{i:1;uuid:"c760b4df-051c-57fd-aed6-8aae94250183"}
D{i:2;uuid:"8e3ab49d-8a66-5ae3-afef-ab0930a2af55"}D{i:3;uuid:"98a2e3b0-22e5-5723-a6e8-7ac3450ab486"}
D{i:4;uuid:"de314f8e-1752-5162-92e1-80f63a4438a6"}
}
##^##*/

