import QtQuick
import QtQuick.Controls
import QtQuick3D
import QtQuick3D.Helpers
import QtQuick.Layouts

Button {
    id: categoryBtn
    width: 188
    height: 160
    text: qsTr("Button")
    icon.source: "DemoUI/CloseBtn_X.png"
    checked: false
    font.pointSize: 20
    font.family: "Archivo"
    checkable: true
    Layout.fillHeight: true
    Layout.fillWidth: true
    icon.color: "#ffffff"
    display: AbstractButton.IconOnly
    background: Rectangle {
        anchors.fill: parent
        radius: 8
        opacity: 1
        color: categoryBtn.pressed ? "#B8B8B9" : (categoryBtn.hovered ? "#5C5C5D" : (categoryBtn.checked ? "#3D3D3E" : "#222222"))
    }

    contentItem: Item {
        id: itemGroup
        Layout.fillHeight: true
        Layout.fillWidth: true

        Label {
            text: categoryBtn.text
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.bottom: parent.bottom
            font.pixelSize: 20
            horizontalAlignment: Text.AlignHCenter
            color: "#ffffff"
            verticalAlignment: Text.AlignBottom
            anchors.bottomMargin: 12
        }

        Image {
            anchors.verticalCenter: parent.verticalCenter
            source: categoryBtn.icon.source
            anchors.verticalCenterOffset: -16
            autoTransform: false
            fillMode: Image.Pad
            anchors.horizontalCenter: parent.horizontalCenter
        }
    }
}
