import QtQuick
import QtQuick3D
import QtQuick3D.Particles3D

ParticleSystem3D {
    id: particleSystem

    property bool show: false
    property real showAnimated: show

    Behavior on showAnimated {
        NumberAnimation {
            duration: 1200
            easing.type: Easing.InOutQuad
        }
    }

    y: (1.0 - showAnimated) * 100
    visible: showAnimated
    paused: !show
    startTime: 10000

    ParticleEmitter3D {
        id: particleEmitter_clouds
        y: 20
        x: -60
        shape: particleShape1
        scale.x: 0.2
        scale.y: 0.2
        scale.z: 0.4
        lifeSpan: 9000
        lifeSpanVariation: 1000
        emitRate: 5
        depthBias: 1000
        velocity: vectorDirection1
        VectorDirection3D {
            id: vectorDirection1
            direction.x: 20
            direction.y: 0
            direction.z: 0
            directionVariation.x: 10
            directionVariation.z: 2
            directionVariation.y: 2
        }

        SpriteParticle3D {
            id: spriteParticle1
            color: "#60ffffff"
            colorVariation.w: 0.2
            maxAmount: 50
            Texture {
                id: singleCloudParticle1
                source: "images/SingleCloudParticle.png"
            }
            fadeOutDuration: 1500
            sprite: singleCloudParticle1
            fadeInDuration: 1500
            billboard: true
            particleScale: 10
        }

        ParticleShape3D {
            id: particleShape1
            type: ParticleShape3D.Sphere
        }
        particleScale: 2
        particleScaleVariation: 1
        particleEndScale: 3
        particleEndScaleVariation: 2
        particleRotationVariation.z: 360
        particle: spriteParticle1
        enabled: true
        system: particleSystem
    }

    ParticleEmitter3D {
        id: particleEmitter_snow
        x: -50
        y: 20
        scale.x: 2
        scale.y: 0
        scale.z: 2
        shape: particleShape
        emitRate: 150
        velocity: vectorDirection2
        VectorDirection3D {
            id: vectorDirection2
            direction.x: 50
            direction.y: -20
            direction.z: 0
            directionVariation.x : 5
            directionVariation.y : 10
            directionVariation.z : 5
        }

        SpriteParticle3D {
            id: spriteParticle2
            color: "#80ffffff"
            sprite: smokeTexture
            maxAmount: 300
            blendMode: SpriteParticle3D.SourceOver
            billboard: true
            fadeInDuration: 0
            fadeOutDuration: 200
            particleScale: 8
            colorVariation.w: 0.3
            Texture {
                id: smokeTexture
                source: "images/sphere.png"
            }
        }

        ParticleShape3D {
            id: particleShape
        }
        particleScale: 0.2
        particleScaleVariation: 0.15
        particleEndScale: 0.3
        particleEndScaleVariation: 0.2
        system: particleSystem
        enabled: true
        particle: spriteParticle2
        lifeSpan: 2800
        lifeSpanVariation: 200
    }
    Wander3D {
        particles: [spriteParticle2]
        uniqueAmount.x: 20
        uniqueAmount.y: 20
        uniqueAmount.z: 20
        uniqueAmountVariation: 0.9
        uniquePace.x: 0.1
        uniquePace.y: 0.1
        uniquePace.z: 0.1
        uniquePaceVariation: 0.6
    }
    Wander3D {
        particles: [spriteParticle1]
        uniqueAmount.x: 10
        uniqueAmount.y: 10
        uniqueAmount.z: 10
        uniqueAmountVariation: 0.9
        uniquePace.x: 0.08
        uniquePace.y: 0.08
        uniquePace.z: 0.08
        uniquePaceVariation: 0.6
    }
}
