import QtQuick
import QtQuick.Studio.DesignEffects

Item {
    id: root
    width: 10
    height: 10
    property bool isActive: true
    property color backColor: "#ffffff"
    property color highlightColor: "#49ff00"

    Rectangle {
        id: activeIndicatorBack
        color: root.backColor
        radius: 5
        anchors.fill: parent
    }

    Rectangle {
        id: activeIndicatorFront
        visible: root.isActive
        color: root.highlightColor
        radius: 5
        anchors.fill: parent
        DesignEffect {
            id: designEffectIndiFront
            layerBlurRadius: 3

            effects: [
                DesignDropShadow {
                    id: designDropShadowDialBack
                    blur: 4
                    offsetX: 0
                    offsetY: 0
                    color: root.highlightColor
                }
            ]
        }
    }
}
