/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.maven.ArtifactFilterManager;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.internal.PlexusUtilsInjector;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.apache.maven.plugin.internal.WagonExcluder;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.RequestTrace;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.collection.DependencyGraphTransformer;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactDescriptorException;
import org.sonatype.aether.resolution.ArtifactDescriptorRequest;
import org.sonatype.aether.resolution.ArtifactDescriptorResult;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.util.DefaultRequestTrace;
import org.sonatype.aether.util.FilterRepositorySystemSession;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.filter.AndDependencyFilter;
import org.sonatype.aether.util.filter.ExclusionsDependencyFilter;
import org.sonatype.aether.util.filter.ScopeDependencyFilter;
import org.sonatype.aether.util.graph.selector.AndDependencySelector;
import org.sonatype.aether.util.graph.transformer.ChainedDependencyGraphTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=PluginDependenciesResolver.class)
public class DefaultPluginDependenciesResolver
implements PluginDependenciesResolver {
    private static final String REPOSITORY_CONTEXT = "plugin";
    @Requirement
    private Logger logger;
    @Requirement
    private ArtifactFilterManager artifactFilterManager;
    @Requirement
    private RepositorySystem repoSystem;

    private Artifact toArtifact(Plugin plugin, RepositorySystemSession session) {
        return new DefaultArtifact(plugin.getGroupId(), plugin.getArtifactId(), null, "jar", plugin.getVersion(), session.getArtifactTypeRegistry().get("maven-plugin"));
    }

    @Override
    public Artifact resolve(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        RequestTrace trace = DefaultRequestTrace.newChild(null, (Object)plugin);
        Artifact pluginArtifact = this.toArtifact(plugin, session);
        try {
            FilterRepositorySystemSession pluginSession = new FilterRepositorySystemSession(session){

                public boolean isIgnoreMissingArtifactDescriptor() {
                    return false;
                }
            };
            ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(pluginArtifact, repositories, REPOSITORY_CONTEXT);
            request.setTrace(trace);
            ArtifactDescriptorResult result = this.repoSystem.readArtifactDescriptor((RepositorySystemSession)pluginSession, request);
            pluginArtifact = result.getArtifact();
            String requiredMavenVersion = (String)result.getProperties().get("prerequisites.maven");
            if (requiredMavenVersion != null) {
                LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(pluginArtifact.getProperties());
                props.put("requiredMavenVersion", requiredMavenVersion);
                pluginArtifact = pluginArtifact.setProperties(props);
            }
        }
        catch (ArtifactDescriptorException e) {
            throw new PluginResolutionException(plugin, (Throwable)e);
        }
        try {
            ArtifactRequest request = new ArtifactRequest(pluginArtifact, repositories, REPOSITORY_CONTEXT);
            request.setTrace(trace);
            pluginArtifact = this.repoSystem.resolveArtifact(session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new PluginResolutionException(plugin, (Throwable)e);
        }
        return pluginArtifact;
    }

    @Override
    public DependencyNode resolve(Plugin plugin, Artifact pluginArtifact, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        DependencyNode node;
        RequestTrace trace = DefaultRequestTrace.newChild(null, (Object)plugin);
        if (pluginArtifact == null) {
            pluginArtifact = this.toArtifact(plugin, session);
        }
        ScopeDependencyFilter collectionFilter = new ScopeDependencyFilter(new String[]{"provided", "test"});
        ExclusionsDependencyFilter resolutionFilter = new ExclusionsDependencyFilter(this.artifactFilterManager.getCoreArtifactExcludes());
        resolutionFilter = AndDependencyFilter.newInstance((DependencyFilter)resolutionFilter, (DependencyFilter)dependencyFilter);
        resolutionFilter = new AndDependencyFilter(new DependencyFilter[]{collectionFilter, resolutionFilter});
        try {
            DependencySelector selector = AndDependencySelector.newInstance((DependencySelector)session.getDependencySelector(), (DependencySelector)new WagonExcluder());
            DependencyGraphTransformer transformer = ChainedDependencyGraphTransformer.newInstance((DependencyGraphTransformer)session.getDependencyGraphTransformer(), (DependencyGraphTransformer)new PlexusUtilsInjector());
            DefaultRepositorySystemSession pluginSession = new DefaultRepositorySystemSession(session);
            pluginSession.setDependencySelector(selector);
            pluginSession.setDependencyGraphTransformer(transformer);
            CollectRequest request = new CollectRequest();
            request.setRequestContext(REPOSITORY_CONTEXT);
            request.setRepositories(repositories);
            request.setRoot(new org.sonatype.aether.graph.Dependency(pluginArtifact, null));
            for (Dependency dependency : plugin.getDependencies()) {
                org.sonatype.aether.graph.Dependency pluginDep = RepositoryUtils.toDependency(dependency, session.getArtifactTypeRegistry());
                if (!"system".equals(pluginDep.getScope())) {
                    pluginDep = pluginDep.setScope("runtime");
                }
                request.addDependency(pluginDep);
            }
            DependencyRequest depRequest = new DependencyRequest(request, (DependencyFilter)resolutionFilter);
            depRequest.setTrace(trace);
            request.setTrace(DefaultRequestTrace.newChild((RequestTrace)trace, (Object)depRequest));
            node = this.repoSystem.collectDependencies((RepositorySystemSession)pluginSession, request).getRoot();
            if (this.logger.isDebugEnabled()) {
                node.accept((DependencyVisitor)new GraphLogger());
            }
            depRequest.setRoot(node);
            this.repoSystem.resolveDependencies(session, depRequest);
        }
        catch (DependencyCollectionException e) {
            throw new PluginResolutionException(plugin, (Throwable)e);
        }
        catch (DependencyResolutionException e) {
            throw new PluginResolutionException(plugin, e.getCause());
        }
        return node;
    }

    class GraphLogger
    implements DependencyVisitor {
        private String indent = "";

        GraphLogger() {
        }

        public boolean visitEnter(DependencyNode node) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(this.indent);
            org.sonatype.aether.graph.Dependency dep = node.getDependency();
            if (dep != null) {
                Artifact art = dep.getArtifact();
                buffer.append(art);
                buffer.append(':').append(dep.getScope());
                if (node.getPremanagedScope() != null && !node.getPremanagedScope().equals(dep.getScope())) {
                    buffer.append(" (scope managed from ").append(node.getPremanagedScope()).append(")");
                }
                if (node.getPremanagedVersion() != null && !node.getPremanagedVersion().equals(art.getVersion())) {
                    buffer.append(" (version managed from ").append(node.getPremanagedVersion()).append(")");
                }
            }
            DefaultPluginDependenciesResolver.this.logger.debug(buffer.toString());
            this.indent = this.indent + "   ";
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            this.indent = this.indent.substring(0, this.indent.length() - 3);
            return true;
        }
    }
}

