/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="set-system-properties", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class SetSystemPropertiesMojo
extends AbstractMojo {
    @Parameter(required=true)
    private Properties properties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.properties.isEmpty()) {
            this.getLog().debug((CharSequence)"No system properties found");
            return;
        }
        this.getLog().debug((CharSequence)"Setting system properties:");
        Enumeration<?> propertyNames = this.properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = propertyNames.nextElement().toString();
            String propertyValue = this.properties.getProperty(propertyName);
            this.getLog().debug((CharSequence)("- " + propertyName + " = " + propertyValue));
            System.setProperty(propertyName, propertyValue);
        }
        int count = this.properties.size();
        this.getLog().info((CharSequence)("Set " + count + " system " + (count > 1 ? "properties" : "property")));
    }
}

