/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.tregex.parser.RegexFeatureSet;
import com.oracle.truffle.regex.tregex.parser.flavors.PythonFlavor;
import com.oracle.truffle.regex.tregex.parser.flavors.RegexFlavor;
import java.util.Arrays;

public final class RegexOptions {
    private static final int U180E_WHITESPACE = 1;
    public static final String U180E_WHITESPACE_NAME = "U180EWhitespace";
    private static final int REGRESSION_TEST_MODE = 2;
    public static final String REGRESSION_TEST_MODE_NAME = "RegressionTestMode";
    private static final int DUMP_AUTOMATA = 4;
    public static final String DUMP_AUTOMATA_NAME = "DumpAutomata";
    private static final int STEP_EXECUTION = 8;
    public static final String STEP_EXECUTION_NAME = "StepExecution";
    private static final int ALWAYS_EAGER = 16;
    public static final String ALWAYS_EAGER_NAME = "AlwaysEager";
    private static final int UTF_16_EXPLODE_ASTRAL_SYMBOLS = 32;
    public static final String UTF_16_EXPLODE_ASTRAL_SYMBOLS_NAME = "UTF16ExplodeAstralSymbols";
    private static final String FLAVOR_NAME = "Flavor";
    private static final String FLAVOR_PYTHON_STR = "PythonStr";
    private static final String FLAVOR_PYTHON_BYTES = "PythonBytes";
    private static final String FLAVOR_ECMASCRIPT = "ECMAScript";
    private static final String FEATURE_SET_NAME = "FeatureSet";
    private static final String FEATURE_SET_TREGEX_JONI = "TRegexJoni";
    private static final String FEATURE_SET_JONI = "Joni";
    public static final RegexOptions DEFAULT = new RegexOptions(0, null, RegexFeatureSet.DEFAULT);
    private final int options;
    private final RegexFlavor flavor;
    private final RegexFeatureSet featureSet;

    private RegexOptions(int options, RegexFlavor flavor, RegexFeatureSet featureSet) {
        assert (flavor == null || featureSet == RegexFeatureSet.DEFAULT);
        this.options = options;
        this.flavor = flavor;
        this.featureSet = featureSet;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @CompilerDirectives.TruffleBoundary
    public static RegexOptions parse(String optionsString) throws RegexSyntaxException {
        int options = 32;
        RegexFlavor flavor = null;
        RegexFeatureSet featureSet = RegexFeatureSet.DEFAULT;
        block20: for (String propValue : optionsString.split(",")) {
            if (propValue.isEmpty()) continue;
            int eqlPos = propValue.indexOf(61);
            if (eqlPos < 0) {
                throw RegexOptions.optionsSyntaxError(optionsString, propValue + " is not in form 'key=value'");
            }
            String key = propValue.substring(0, eqlPos);
            String value = propValue.substring(eqlPos + 1);
            switch (key) {
                case "U180EWhitespace": {
                    options = RegexOptions.parseBooleanOption(optionsString, options, key, value, 1);
                    continue block20;
                }
                case "RegressionTestMode": {
                    options = RegexOptions.parseBooleanOption(optionsString, options, key, value, 2);
                    continue block20;
                }
                case "DumpAutomata": {
                    options = RegexOptions.parseBooleanOption(optionsString, options, key, value, 4);
                    continue block20;
                }
                case "StepExecution": {
                    options = RegexOptions.parseBooleanOption(optionsString, options, key, value, 8);
                    continue block20;
                }
                case "AlwaysEager": {
                    options = RegexOptions.parseBooleanOption(optionsString, options, key, value, 16);
                    continue block20;
                }
                case "UTF16ExplodeAstralSymbols": {
                    options = RegexOptions.parseBooleanOption(optionsString, options, key, value, 32);
                    continue block20;
                }
                case "Flavor": {
                    flavor = RegexOptions.parseFlavor(optionsString, value);
                    continue block20;
                }
                case "FeatureSet": {
                    featureSet = RegexOptions.parseFeatureSet(optionsString, value);
                    continue block20;
                }
                default: {
                    throw RegexOptions.optionsSyntaxError(optionsString, "unexpected option " + key);
                }
            }
        }
        return new RegexOptions(options, flavor, featureSet);
    }

    private static int parseBooleanOption(String optionsString, int options, String key, String value, int flag) throws RegexSyntaxException {
        if (value.equals("true")) {
            return options | flag;
        }
        if (!value.equals("false")) {
            throw RegexOptions.optionsSyntaxErrorUnexpectedValue(optionsString, key, value, "true", "false");
        }
        return options;
    }

    private static RegexFlavor parseFlavor(String optionsString, String value) throws RegexSyntaxException {
        switch (value) {
            case "PythonStr": {
                return PythonFlavor.STR_INSTANCE;
            }
            case "PythonBytes": {
                return PythonFlavor.BYTES_INSTANCE;
            }
            case "ECMAScript": {
                return null;
            }
        }
        throw RegexOptions.optionsSyntaxErrorUnexpectedValue(optionsString, FLAVOR_NAME, value, FLAVOR_PYTHON_STR, FLAVOR_PYTHON_BYTES, FLAVOR_ECMASCRIPT);
    }

    private static RegexFeatureSet parseFeatureSet(String optionsString, String value) throws RegexSyntaxException {
        switch (value) {
            case "TRegexJoni": {
                return RegexFeatureSet.TREGEX_JONI;
            }
            case "Joni": {
                return RegexFeatureSet.JONI;
            }
        }
        throw RegexOptions.optionsSyntaxErrorUnexpectedValue(optionsString, FEATURE_SET_NAME, value, FEATURE_SET_TREGEX_JONI, FEATURE_SET_JONI);
    }

    private static RegexSyntaxException optionsSyntaxErrorUnexpectedValue(String optionsString, String key, String value, String ... expectedValues) {
        return RegexOptions.optionsSyntaxError(optionsString, String.format("unexpected value '%s' for option '%s', expected one of %s", value, key, Arrays.toString(expectedValues)));
    }

    private static RegexSyntaxException optionsSyntaxError(String optionsString, String msg) {
        return new RegexSyntaxException(String.format("Invalid options syntax in '%s': %s", optionsString, msg));
    }

    private boolean isBitSet(int bit) {
        return (this.options & bit) != 0;
    }

    public boolean isU180EWhitespace() {
        return this.isBitSet(1);
    }

    public boolean isRegressionTestMode() {
        return this.isBitSet(2);
    }

    public boolean isDumpAutomata() {
        return this.isBitSet(4);
    }

    public boolean isStepExecution() {
        return this.isBitSet(8);
    }

    public boolean isAlwaysEager() {
        return this.isBitSet(16);
    }

    public boolean isUTF16ExplodeAstralSymbols() {
        return this.isBitSet(32);
    }

    public RegexOptions withoutUTF16ExplodeAstralSymbols() {
        return new RegexOptions(this.options & 0xFFFFFFDF, this.flavor, this.featureSet);
    }

    public RegexFlavor getFlavor() {
        return this.flavor;
    }

    public RegexFeatureSet getFeatureSet() {
        return this.featureSet;
    }

    public int hashCode() {
        int flavorHash = this.flavor == null ? 0 : this.flavor.hashCode();
        return this.options + 13 * flavorHash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RegexOptions)) {
            return false;
        }
        RegexOptions other = (RegexOptions)obj;
        return this.options == other.options && this.flavor == other.flavor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isU180EWhitespace()) {
            sb.append("U180EWhitespace=true,");
        }
        if (this.isRegressionTestMode()) {
            sb.append("RegressionTestMode=true,");
        }
        if (this.isDumpAutomata()) {
            sb.append("DumpAutomata=true,");
        }
        if (this.isStepExecution()) {
            sb.append("StepExecution=true,");
        }
        if (this.isAlwaysEager()) {
            sb.append("AlwaysEager=true,");
        }
        if (this.flavor == PythonFlavor.STR_INSTANCE) {
            sb.append("Flavor=PythonStr,");
        } else if (this.flavor == PythonFlavor.BYTES_INSTANCE) {
            sb.append("Flavor=PythonBytes,");
        }
        if (this.featureSet == RegexFeatureSet.TREGEX_JONI) {
            sb.append("FeatureSet=TRegexJoni,");
        } else if (this.featureSet == RegexFeatureSet.JONI) {
            sb.append("FeatureSet=Joni,");
        }
        return sb.toString();
    }

    public static final class Builder {
        private int options = 0;
        private RegexFlavor flavor = null;
        private RegexFeatureSet featureSet = RegexFeatureSet.DEFAULT;

        private Builder() {
        }

        public Builder u180eWhitespace(boolean enabled) {
            this.updateOption(enabled, 1);
            return this;
        }

        public Builder regressionTestMode(boolean enabled) {
            this.updateOption(enabled, 2);
            return this;
        }

        public Builder dumpAutomata(boolean enabled) {
            this.updateOption(enabled, 4);
            return this;
        }

        public Builder stepExecution(boolean enabled) {
            this.updateOption(enabled, 8);
            return this;
        }

        public Builder alwaysEager(boolean enabled) {
            this.updateOption(enabled, 16);
            return this;
        }

        public Builder utf16ExplodeAstralSymbols(boolean enabled) {
            this.updateOption(enabled, 32);
            return this;
        }

        public Builder flavor(RegexFlavor flavor) {
            this.flavor = flavor;
            return this;
        }

        public Builder featureSet(RegexFeatureSet featureSet) {
            this.featureSet = featureSet;
            return this;
        }

        public RegexOptions build() {
            return new RegexOptions(this.options, this.flavor, this.featureSet);
        }

        private void updateOption(boolean enabled, int bitMask) {
            this.options = enabled ? (this.options |= bitMask) : (this.options &= ~bitMask);
        }
    }
}

