/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.util;

import java.io.File;
import java.util.Collection;
import org.apache.maven.surefire.testset.TestFilter;
import org.apache.maven.surefire.util.internal.StringUtils;

final class FileScanner {
    private final File basedir;
    private final String ext;

    FileScanner(File basedir, String ext) {
        this.basedir = basedir;
        ext = ext.trim();
        if (StringUtils.isBlank((String)ext)) {
            throw new IllegalArgumentException("No file extension");
        }
        this.ext = ext.startsWith(".") ? ext : "." + ext;
    }

    void scanTo(Collection<String> scannedJavaClassNames, TestFilter<String, String> filter) {
        this.scan(scannedJavaClassNames, filter, this.basedir, new String[0]);
    }

    private void scan(Collection<String> scannedJavaClassNames, TestFilter<String, String> filter, File basedir, String ... subDirectories) {
        File[] filesAndDirs = basedir.listFiles();
        if (filesAndDirs != null) {
            String pAckage = FileScanner.toJavaPackage(subDirectories);
            String path = FileScanner.toPath(subDirectories);
            String ext = this.ext;
            boolean hasExtension = ext != null;
            int extLength = hasExtension ? ext.length() : 0;
            for (File fileOrDir : filesAndDirs) {
                String name = fileOrDir.getName();
                if (name.isEmpty()) continue;
                if (fileOrDir.isFile()) {
                    String simpleClassName;
                    int clsLength = name.length() - extLength;
                    if (clsLength <= 0 || hasExtension && !name.regionMatches(true, clsLength, ext, 0, extLength)) continue;
                    String string = simpleClassName = hasExtension ? name.substring(0, clsLength) : name;
                    if (!filter.shouldRun((Object)this.toFile(path, simpleClassName), null)) continue;
                    String fullyQualifiedClassName = pAckage.isEmpty() ? simpleClassName : pAckage + '.' + simpleClassName;
                    scannedJavaClassNames.add(fullyQualifiedClassName);
                    continue;
                }
                if (!fileOrDir.isDirectory()) continue;
                String[] paths = new String[subDirectories.length + 1];
                System.arraycopy(subDirectories, 0, paths, 0, subDirectories.length);
                paths[subDirectories.length] = name;
                this.scan(scannedJavaClassNames, filter, fileOrDir, paths);
            }
        }
    }

    private static String toJavaPackage(String ... subDirectories) {
        StringBuilder pkg = new StringBuilder();
        for (int i = 0; i < subDirectories.length; ++i) {
            if (i > 0 && i < subDirectories.length) {
                pkg.append('.');
            }
            pkg.append(subDirectories[i]);
        }
        return pkg.toString();
    }

    private static String toPath(String ... subDirectories) {
        StringBuilder pkg = new StringBuilder();
        for (int i = 0; i < subDirectories.length; ++i) {
            if (i > 0 && i < subDirectories.length) {
                pkg.append('/');
            }
            pkg.append(subDirectories[i]);
        }
        return pkg.toString();
    }

    private String toFile(String path, String fileNameWithoutExtension) {
        String pathWithoutExtension = path.isEmpty() ? fileNameWithoutExtension : path + '/' + fileNameWithoutExtension;
        return pathWithoutExtension + this.ext;
    }
}

