/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.impl.DefaultCallTarget;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;

final class DefaultIndirectCallNode
extends IndirectCallNode {
    DefaultIndirectCallNode() {
    }

    @Override
    public Object call(CallTarget target, Object ... arguments) {
        return ((DefaultCallTarget)target).callDirectOrIndirect(this, arguments);
    }

    static IndirectCallNode createUncached() {
        return new IndirectCallNode(){

            @Override
            public boolean isAdoptable() {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @CompilerDirectives.TruffleBoundary
            public Object call(CallTarget target, Object ... arguments) {
                Node parent = NodeUtil.pushEncapsulatingNode(null);
                try {
                    Object object = ((DefaultCallTarget)target).callDirectOrIndirect(parent, arguments);
                    return object;
                }
                finally {
                    NodeUtil.popEncapsulatingNode(parent);
                }
            }
        };
    }
}

