/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.Map;

public class DefaultESModuleLoader
implements JSModuleLoader {
    protected final JSRealm realm;
    protected final Map<String, JSModuleRecord> moduleMap = new HashMap<String, JSModuleRecord>();

    public static DefaultESModuleLoader create(JSRealm realm) {
        return new DefaultESModuleLoader(realm);
    }

    protected DefaultESModuleLoader(JSRealm realm) {
        this.realm = realm;
    }

    protected URI asURI(String specifier) {
        if (specifier.indexOf(58) == -1) {
            return null;
        }
        try {
            URI uri = new URI(specifier);
            return uri.getScheme() != null ? uri : null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public JSModuleRecord resolveImportedModule(ScriptOrModule referrer, String specifier) {
        String refPath = referrer == null ? null : referrer.getSource().getPath();
        try {
            TruffleFile moduleFile;
            if (refPath == null) {
                URI maybeUri = this.asURI(specifier);
                moduleFile = maybeUri != null ? this.realm.getEnv().getPublicTruffleFile(maybeUri).getCanonicalFile(new LinkOption[0]) : this.realm.getEnv().getPublicTruffleFile(specifier).getCanonicalFile(new LinkOption[0]);
            } else {
                TruffleFile refFile = this.realm.getEnv().getPublicTruffleFile(refPath);
                moduleFile = refFile.resolveSibling(specifier).getCanonicalFile(new LinkOption[0]);
            }
            String canonicalPath = moduleFile.getPath();
            return this.loadModuleFromUrl(specifier, moduleFile, canonicalPath);
        }
        catch (IOException | SecurityException e) {
            throw Errors.createErrorFromException(e);
        }
    }

    protected JSModuleRecord loadModuleFromUrl(String specifier, TruffleFile moduleFile, String canonicalPath) throws IOException {
        JSModuleRecord existingModule = this.moduleMap.get(canonicalPath);
        if (existingModule != null) {
            return existingModule;
        }
        Source source = Source.newBuilder((String)"js", (TruffleFile)moduleFile).name(specifier).build();
        JSModuleRecord newModule = this.realm.getContext().getEvaluator().parseModule(this.realm.getContext(), source, this);
        this.moduleMap.put(canonicalPath, newModule);
        return newModule;
    }

    @Override
    public JSModuleRecord loadModule(Source source) {
        String canonicalPath;
        String path = source.getPath();
        if (path == null) {
            canonicalPath = source.getName();
        } else {
            try {
                TruffleFile moduleFile = this.realm.getEnv().getPublicTruffleFile(path);
                canonicalPath = moduleFile.getCanonicalFile(new LinkOption[0]).getPath();
            }
            catch (IOException | SecurityException e) {
                throw Errors.createErrorFromException(e);
            }
        }
        return this.moduleMap.computeIfAbsent(canonicalPath, key -> this.realm.getContext().getEvaluator().parseModule(this.realm.getContext(), source, this));
    }
}

