/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSReadCurrentFrameSlotNodeGen;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.util.Set;

abstract class JSReadCurrentFrameSlotNode
extends JSReadFrameSlotNode {
    JSReadCurrentFrameSlotNode(FrameSlot slot) {
        super(slot);
    }

    @Specialization(guards={"frame.isBoolean(frameSlot)"})
    protected final boolean doBoolean(VirtualFrame frame) {
        return super.getBoolean((Frame)frame);
    }

    @Specialization(guards={"frame.isInt(frameSlot)"})
    protected final int doInt(VirtualFrame frame) {
        return super.getInt((Frame)frame);
    }

    @Specialization(guards={"frame.isDouble(frameSlot)"})
    protected final double doDouble(VirtualFrame frame) {
        return super.getDouble((Frame)frame);
    }

    @Specialization(guards={"frame.isObject(frameSlot)"})
    protected final Object doObject(VirtualFrame frame) {
        return super.getObject((Frame)frame);
    }

    @Specialization(guards={"frame.isLong(frameSlot)"})
    protected final SafeInteger doSafeInteger(VirtualFrame frame) {
        return SafeInteger.valueOf(super.getLong((Frame)frame));
    }

    @Override
    public ScopeFrameNode getLevelFrameNode() {
        return ScopeFrameNode.create(0);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSReadCurrentFrameSlotNodeGen.create(this.frameSlot);
    }
}

