/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web.servlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.chain.web.MapEntry;

final class ServletCookieMap
implements Map {
    private HttpServletRequest request = null;

    public ServletCookieMap(HttpServletRequest request) {
        this.request = request;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public Set entrySet() {
        HashSet<MapEntry> set = new HashSet<MapEntry>();
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                set.add(new MapEntry(cookies[i].getName(), cookies[i], false));
            }
        }
        return set;
    }

    public boolean equals(Object o) {
        return this.request.equals(o);
    }

    public Object get(Object key) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(this.key(key))) continue;
                return cookies[i];
            }
        }
        return null;
    }

    public int hashCode() {
        return this.request.hashCode();
    }

    public boolean isEmpty() {
        return this.size() < 1;
    }

    public Set keySet() {
        HashSet<String> set = new HashSet<String>();
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                set.add(cookies[i].getName());
            }
        }
        return set;
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        Cookie[] cookies = this.request.getCookies();
        return cookies == null ? 0 : cookies.length;
    }

    public Collection values() {
        ArrayList<Cookie> list = new ArrayList<Cookie>(this.size());
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                list.add(cookies[i]);
            }
        }
        return list;
    }

    private String key(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key instanceof String) {
            return (String)key;
        }
        return key.toString();
    }
}

