/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.unary.FlattenNodeGen;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.PropertyReference;

public abstract class FlattenNode
extends JavaScriptBaseNode {
    FlattenNode() {
    }

    public abstract Object execute(Object var1);

    @Specialization
    protected static String doLazyString(JSLazyString value, @Cached(value="createBinaryProfile()") ConditionProfile flatten) {
        return value.toString(flatten);
    }

    @Specialization
    protected static String doLazyString(PropertyReference value) {
        return value.toString();
    }

    @Specialization
    protected static double doSafeInteger(SafeInteger value) {
        return value.doubleValue();
    }

    @Fallback
    protected static Object doOther(Object value) {
        assert (!JSRuntime.isLazyString(value));
        return value;
    }

    public static FlattenNode create() {
        return FlattenNodeGen.create();
    }
}

