/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.SingleRowResultSet;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class TriggerResultSet
extends SingleRowResultSet {
    private ArrayList m_tupleChanges;
    private final Tuple m_tuple;
    private final boolean m_readOnly;

    public TriggerResultSet(TupleDesc tupleDesc, Tuple tuple, boolean readOnly) throws SQLException {
        super(tupleDesc);
        this.m_tuple = tuple;
        this.m_readOnly = readOnly;
    }

    public void cancelRowUpdates() throws SQLException {
        this.m_tupleChanges = null;
    }

    public int getConcurrency() throws SQLException {
        return this.m_readOnly ? 1007 : 1008;
    }

    public boolean rowUpdated() throws SQLException {
        return this.m_tupleChanges != null;
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        if (this.m_readOnly) {
            throw new UnsupportedFeatureException("ResultSet is read-only");
        }
        if (this.m_tupleChanges == null) {
            this.m_tupleChanges = new ArrayList();
        }
        this.m_tupleChanges.add(new Integer(columnIndex));
        this.m_tupleChanges.add(x);
    }

    public Object[] getChangeIndexesAndValues() {
        ArrayList changes = this.m_tupleChanges;
        if (changes == null) {
            return null;
        }
        int top = changes.size();
        if (changes.size() == 0) {
            return null;
        }
        int[] indexes = new int[top /= 2];
        Object[] values = new Object[top];
        int vIdx = 0;
        int idx = 0;
        while (idx < top) {
            indexes[idx] = (Integer)changes.get(vIdx++);
            values[idx] = changes.get(vIdx++);
            ++idx;
        }
        return new Object[]{this.m_tuple, indexes, values};
    }

    protected Object getObjectValue(int columnIndex) throws SQLException {
        ArrayList changes = this.m_tupleChanges;
        if (changes != null) {
            int top = changes.size();
            int idx = 0;
            while (idx < top) {
                if (columnIndex == (Integer)changes.get(idx)) {
                    return changes.get(idx + 1);
                }
                idx += 2;
            }
        }
        return this.m_tuple.getObject(this.getTupleDesc(), columnIndex);
    }
}

