/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.postgresql.pljava.Server;
import org.postgresql.pljava.TriggerData;
import org.postgresql.pljava.TriggerException;

public class Triggers {
    static void insertUsername(TriggerData td) throws SQLException {
        if (td.isFiredForStatement()) {
            throw new TriggerException(td, "can't process STATEMENT events");
        }
        if (td.isFiredAfter()) {
            throw new TriggerException(td, "must be fired before event");
        }
        if (td.isFiredByDelete()) {
            throw new TriggerException(td, "can't process DELETE events");
        }
        ResultSet _new = td.getNew();
        String[] args = td.getArguments();
        if (args.length != 1) {
            throw new TriggerException(td, "one argument was expected");
        }
        if (_new.getString(args[0]) == null) {
            _new.updateString(args[0], Server.getUserName());
        }
    }

    static void moddatetime(TriggerData td) throws SQLException {
        if (td.isFiredForStatement()) {
            throw new TriggerException(td, "can't process STATEMENT events");
        }
        if (td.isFiredAfter()) {
            throw new TriggerException(td, "must be fired before event");
        }
        if (!td.isFiredByUpdate()) {
            throw new TriggerException(td, "can only process UPDATE events");
        }
        ResultSet _new = td.getNew();
        String[] args = td.getArguments();
        if (args.length != 1) {
            throw new TriggerException(td, "one argument was expected");
        }
        _new.updateTimestamp(args[0], new Timestamp(System.currentTimeMillis()));
    }
}

