/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.jdbc.SPISavepoint;

public class Invocation {
    private static Invocation[] s_levels = new Invocation[10];
    private final int m_nestingLevel;
    private SPISavepoint m_savepoint;
    private ArrayList m_preparedStatements;

    private Invocation(int n) {
        this.m_nestingLevel = n;
    }

    public int getNestingLevel() {
        return this.m_nestingLevel;
    }

    final SPISavepoint getSavepoint() {
        return this.m_savepoint;
    }

    final void manageStatement(PreparedStatement preparedStatement) {
        if (this.m_preparedStatements == null) {
            this.m_preparedStatements = new ArrayList();
        }
        this.m_preparedStatements.add(preparedStatement);
    }

    final void forgetStatement(PreparedStatement preparedStatement) {
        if (this.m_preparedStatements == null) {
            return;
        }
        int n = this.m_preparedStatements.size();
        while (--n >= 0) {
            if (this.m_preparedStatements.get(n) != preparedStatement) continue;
            this.m_preparedStatements.remove(n);
            return;
        }
    }

    final void setSavepoint(SPISavepoint sPISavepoint) {
        this.m_savepoint = sPISavepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExit() throws SQLException {
        try {
            int n;
            if (this.m_savepoint != null) {
                this.m_savepoint.onInvocationExit();
            }
            if (this.m_preparedStatements != null && (n = this.m_preparedStatements.size()) > 0) {
                Logger logger = Logger.getAnonymousLogger();
                logger.warning("Closing " + n + " \"forgotten\" statement" + (n > 1 ? "s" : ""));
                while (--n >= 0) {
                    PreparedStatement preparedStatement = (PreparedStatement)this.m_preparedStatements.get(n);
                    logger.fine("Closed: " + preparedStatement);
                    preparedStatement.close();
                }
            }
        }
        finally {
            Invocation.s_levels[this.m_nestingLevel] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Invocation current() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            int n;
            Invocation invocation = Invocation._getCurrent();
            if (invocation != null) {
                return invocation;
            }
            int n2 = Invocation._getNestingLevel();
            if (n2 < (n = s_levels.length)) {
                invocation = s_levels[n2];
                if (invocation != null) {
                    invocation._register();
                    return invocation;
                }
            } else {
                int n3 = n;
                while ((n3 <<= 2) <= n2) {
                }
                Invocation[] invocationArray = new Invocation[n3];
                System.arraycopy(s_levels, 0, invocationArray, 0, n);
                s_levels = invocationArray;
            }
            Invocation.s_levels[n2] = invocation = new Invocation(n2);
            invocation._register();
            return invocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearErrorCondition() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            Invocation._clearErrorCondition();
        }
    }

    private native void _register();

    private static native Invocation _getCurrent();

    private static native int _getNestingLevel();

    private static native void _clearErrorCondition();
}

