/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.PropertyPermission;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgresql.pljava.internal.Session;
import org.postgresql.pljava.management.Commands;

public class Backend {
    public static final Object THREADLOCK = new Object();
    private static Session s_session;
    private static boolean s_inSetTrusted;
    private static final SecurityManager s_untrustedSecurityManager;
    private static final SecurityManager s_trustedSecurityManager;

    public static synchronized Session getSession() {
        if (s_session == null) {
            s_session = new Session();
        }
        return s_session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfigOption(String string) {
        Object object = THREADLOCK;
        synchronized (object) {
            return Backend._getConfigOption(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStatementCacheSize() {
        Object object = THREADLOCK;
        synchronized (object) {
            return Backend._getStatementCacheSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(int n, String string) {
        Object object = THREADLOCK;
        synchronized (object) {
            Backend._log(n, string);
        }
    }

    public static void addClassImages(Connection connection, int n, String string) throws SQLException {
        boolean bl;
        InputStream inputStream = null;
        boolean bl2 = bl = System.getSecurityManager() == s_trustedSecurityManager;
        if (bl) {
            Backend.setTrusted(false);
        }
        try {
            URL uRL = new URL(string);
            inputStream = uRL.openStream();
            Commands.addClassImages(connection, n, inputStream);
        }
        catch (IOException iOException) {
            throw new SQLException("I/O exception reading jar file: " + iOException.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bl) {
                Backend.setTrusted(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setTrusted(boolean bl) {
        s_inSetTrusted = true;
        try {
            Logger logger = Logger.getAnonymousLogger();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Using SecurityManager for " + (bl ? "trusted" : "untrusted") + " language");
            }
            System.setSecurityManager(bl ? s_trustedSecurityManager : s_untrustedSecurityManager);
        }
        finally {
            s_inSetTrusted = false;
        }
    }

    public static native boolean isCallingJava();

    public static native boolean isReleaseLingeringSavepoints();

    private static native String _getConfigOption(String var0);

    private static native int _getStatementCacheSize();

    private static native void _log(int var0, String var1);

    static {
        s_inSetTrusted = false;
        s_untrustedSecurityManager = new PLJavaSecurityManager();
        s_trustedSecurityManager = new PLJavaSecurityManager(){

            void assertPermission(Permission permission) {
                if (permission instanceof FilePermission) {
                    String string = permission.getActions();
                    if ("read".equals(string)) {
                        File file = new File(System.getProperty("java.home"));
                        File file2 = new File(permission.getName());
                        for (File file3 = file2.getParentFile(); file3 != null; file3 = file3.getParentFile()) {
                            if (!file3.equals(file)) continue;
                            return;
                        }
                    }
                    throw new SecurityException(permission.getActions() + " on " + permission.getName());
                }
                super.assertPermission(permission);
            }
        };
    }

    private static class PLJavaSecurityManager
    extends SecurityManager {
        private boolean m_recursion = false;

        private PLJavaSecurityManager() {
        }

        public void checkPermission(Permission permission) {
            this.nonRecursiveCheck(permission);
        }

        public void checkPermission(Permission permission, Object object) {
            this.nonRecursiveCheck(permission);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void nonRecursiveCheck(Permission permission) {
            if (this.m_recursion) {
                return;
            }
            this.m_recursion = true;
            try {
                this.assertPermission(permission);
            }
            finally {
                this.m_recursion = false;
            }
        }

        void assertPermission(Permission permission) {
            String string;
            if (permission instanceof RuntimePermission) {
                String string2 = permission.getName();
                if ("*".equals(string2) || "exitVM".equals(string2)) {
                    throw new SecurityException();
                }
                if ("setSecurityManager".equals(string2) && !s_inSetTrusted) {
                    throw new SecurityException();
                }
            } else if (permission instanceof PropertyPermission && permission.getActions().indexOf("write") >= 0 && (string = permission.getName()).equals("java.home")) {
                throw new SecurityException();
            }
        }
    }
}

