/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaDataTest {
    private String m_methodName;
    private Object[] m_methodArgs;
    private Class[] m_methodArgTypes;
    private ArrayList m_results;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$I;

    public static Iterator callMetaDataMethod(String string) throws SQLException {
        return new MetaDataTest(string).iterator();
    }

    public MetaDataTest(String string) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        this.m_results = new ArrayList();
        this.parseMethodCall(string);
        try {
            Method method = DatabaseMetaData.class.getMethod(this.m_methodName, this.m_methodArgTypes);
            if (!method.getReturnType().equals(ResultSet.class)) {
                throw new NoSuchMethodException("Unexpected return type");
            }
            ResultSet resultSet = (ResultSet)method.invoke((Object)databaseMetaData, this.m_methodArgs);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i <= n; ++i) {
                stringBuffer.append((resultSetMetaData.getColumnName(i) + "(" + resultSetMetaData.getColumnClassName(i) + ")").replaceAll("(\\\\|;)", "\\$1") + ";");
            }
            this.m_results.add(stringBuffer.toString());
            while (resultSet.next()) {
                stringBuffer = new StringBuffer();
                Object object = null;
                for (int i = 1; i <= n; ++i) {
                    object = resultSet.getObject(i);
                    if (object == null) {
                        object = "<NULL>";
                    }
                    stringBuffer.append(object.toString().replaceAll("(\\\\|;)", "\\$1") + ";");
                }
                this.m_results.add(stringBuffer.toString());
            }
            resultSet.close();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.m_methodArgTypes.length; ++i) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.m_methodArgTypes[i].getName());
            }
            throw new SQLException("No such method or non-resultset return type: " + this.m_methodName + "(" + stringBuffer.toString() + ")");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException.getTargetException().toString());
        }
        catch (Exception exception) {
            throw new SQLException("Method error: " + exception.toString());
        }
    }

    private Iterator iterator() {
        return this.m_results.iterator();
    }

    public void close() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseMethodCall(String string) throws SQLException {
        try {
            Pattern pattern = Pattern.compile("^\\s*([a-zA-Z_][a-zA-Z0-9_]*)\\s*\\((.*)\\)\\s*$");
            Matcher matcher = pattern.matcher(string);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Class<Integer>> arrayList2 = new ArrayList<Class<Integer>>();
            if (!matcher.matches()) throw new SQLException("Syntax error");
            this.m_methodName = matcher.group(1);
            String string2 = matcher.group(2).trim();
            pattern = Pattern.compile("^\\s*(\\(\\s*(?:String|int)\\s*(?:\\[\\s*\\])?\\s*\\)\\s*null|TRUE|FALSE|(?:\\-|\\+)?[0-9]+|\\[((?:[^\\[\\]])*)\\]|\"((?:[^\\\\\"]|\\\\.)*)\"|\\{((?:[^\\{\\}]|\"(?:[^\\\\\"]|\\\\.)*\")*)\\})\\s*(?:,|$)(.*)$");
            String string3 = string2;
            while (!string3.equals("")) {
                Matcher matcher2;
                ArrayList<Object> arrayList3;
                String string4;
                Pattern pattern2;
                matcher = pattern.matcher(string3);
                if (!matcher.matches()) {
                    throw new SQLException("Invalid parameter list: " + string2);
                }
                String string5 = matcher.group(1);
                if (string5.startsWith("\"")) {
                    string5 = matcher.group(3);
                    arrayList.add(string5);
                    arrayList2.add(class$java$lang$String == null ? MetaDataTest.class$("java.lang.String") : class$java$lang$String);
                } else if (string5.startsWith("{")) {
                    string5 = matcher.group(4);
                    pattern2 = Pattern.compile("^\\s*\"((?:[^\\\\\"]|\\\\.)*)\"\\s*(?:,|$)(.*)$");
                    string4 = string5.trim();
                    arrayList3 = new ArrayList<Object>();
                    while (!string4.equals("")) {
                        matcher2 = pattern2.matcher(string4);
                        if (!matcher2.matches()) {
                            throw new SQLException("Invalid string array: " + string5);
                        }
                        arrayList3.add(matcher2.group(1));
                        string4 = matcher2.group(2).trim();
                    }
                    arrayList.add(arrayList3.toArray(new String[0]));
                    arrayList2.add(array$Ljava$lang$String == null ? MetaDataTest.class$("[Ljava.lang.String;") : array$Ljava$lang$String);
                } else if (string5.equals("TRUE") || string5.equals("FALSE")) {
                    arrayList.add(new Boolean(string5));
                    arrayList2.add(Boolean.TYPE);
                } else if (string5.startsWith("(")) {
                    pattern2 = Pattern.compile("^\\(\\s*(String|int)\\s*(\\[\\s*\\])?\\s*\\)\\s*null\\s*$");
                    matcher2 = pattern2.matcher(string5);
                    if (!matcher2.matches()) throw new SQLException("Invalid null value: " + string5);
                    arrayList.add(null);
                    if (matcher2.group(2) == null) {
                        if (!matcher2.group(1).equals("String")) throw new SQLException("Primitive 'int' cannot be null");
                        arrayList2.add(class$java$lang$String == null ? MetaDataTest.class$("java.lang.String") : class$java$lang$String);
                    } else if (matcher2.group(1).equals("String")) {
                        arrayList2.add(array$Ljava$lang$String == null ? MetaDataTest.class$("[Ljava.lang.String;") : array$Ljava$lang$String);
                    } else {
                        arrayList2.add(array$I == null ? MetaDataTest.class$("[I") : array$I);
                    }
                } else if (string5.startsWith("[")) {
                    string5 = matcher.group(2);
                    pattern2 = Pattern.compile("^\\s*(\\d+)\\s*(?:,|$)(.*)$");
                    string4 = string5.trim();
                    arrayList3 = new ArrayList();
                    while (!string4.equals("")) {
                        matcher2 = pattern2.matcher(string4);
                        if (!matcher2.matches()) {
                            throw new SQLException("Invalid int array: " + string5);
                        }
                        arrayList3.add(new Integer(matcher2.group(1)));
                        string4 = matcher2.group(2).trim();
                    }
                    arrayList.add(arrayList3.toArray(new Integer[0]));
                    arrayList2.add(array$I == null ? MetaDataTest.class$("[I") : array$I);
                } else {
                    arrayList.add(new Integer(string5));
                    arrayList2.add(Integer.TYPE);
                }
                string3 = matcher.group(5).trim();
            }
            this.m_methodArgs = arrayList.toArray(new Object[0]);
            this.m_methodArgTypes = arrayList2.toArray(new Class[0]);
            return;
        }
        catch (Exception exception) {
            throw new SQLException("Invalid method call: " + string + ". Cause: " + exception.toString());
        }
    }
}

