/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.postgresql.pljava.jdbc.Invocation;
import org.postgresql.pljava.jdbc.SPIAnonymousSavepoint;
import org.postgresql.pljava.jdbc.SPIDatabaseMetaData;
import org.postgresql.pljava.jdbc.SPINamedSavepoint;
import org.postgresql.pljava.jdbc.SPIPreparedStatement;
import org.postgresql.pljava.jdbc.SPISavepoint;
import org.postgresql.pljava.jdbc.SPIStatement;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIConnection
implements Connection {
    private static final HashMap s_sqlType2Class = new HashMap(30);
    private int[] VERSION_NUMBER = null;
    public static final String[] JDBC3_TYPE_NAMES;
    public static final int[] JDBC_TYPE_NUMBERS;

    private static final void addType(Class clazz, int n) {
        s_sqlType2Class.put(clazz, new Integer(n));
    }

    public static Connection getDefault() throws SQLException {
        return new SPIConnection();
    }

    public int getHoldability() throws SQLException {
        return 2;
    }

    public int getTransactionIsolation() throws SQLException {
        return 2;
    }

    public void clearWarnings() throws SQLException {
        throw new UnsupportedFeatureException("Connection.clearWarnings");
    }

    public void close() throws SQLException {
    }

    public void commit() throws SQLException {
        throw new UnsupportedFeatureException("Connection.commit");
    }

    public void rollback() throws SQLException {
        throw new UnsupportedFeatureException("Connection.rollback");
    }

    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    public boolean isClosed() throws SQLException {
        return false;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public void setHoldability(int n) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setHoldability");
    }

    public void setTransactionIsolation(int n) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setTransactionIsolation");
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setAutoCommit");
    }

    public void setReadOnly(boolean bl) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setReadOnly");
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public void setCatalog(String string) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setCatalog");
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new SPIDatabaseMetaData(this);
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedFeatureException("Connection.getWarnings");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof SPISavepoint)) {
            throw new IllegalArgumentException("Not an SPISavepoint");
        }
        SPISavepoint sPISavepoint = (SPISavepoint)savepoint;
        sPISavepoint.release();
        SPIConnection.forgetSavepoint(sPISavepoint);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof SPISavepoint)) {
            throw new IllegalArgumentException("Not an SPISavepoint");
        }
        SPISavepoint sPISavepoint = (SPISavepoint)savepoint;
        Invocation.clearErrorCondition();
        sPISavepoint.rollback();
        SPIConnection.forgetSavepoint(sPISavepoint);
    }

    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
        return new SPIStatement(this);
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        if (n != 1003) {
            throw new UnsupportedOperationException("TYPE_FORWARD_ONLY supported ResultSet type");
        }
        if (n2 != 1007) {
            throw new UnsupportedOperationException("CONCUR_READ_ONLY is the supported ResultSet concurrency");
        }
        return this.createStatement();
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n3 != 2) {
            throw new UnsupportedOperationException("CLOSE_CURSORS_AT_COMMIT is the only supported ResultSet holdability");
        }
        return this.createStatement(n, n2);
    }

    public Map getTypeMap() throws SQLException {
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new UnsupportedOperationException("Type map is not yet implemented");
    }

    public String nativeSQL(String string) throws SQLException {
        return this.nativeSQL(string, null);
    }

    public String nativeSQL(String string, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        int n3 = 1;
        block5: for (int i = 0; i < n; ++i) {
            int n4 = string.charAt(i);
            switch (n4) {
                case 92: {
                    stringBuffer.append((char)n4);
                    if (++i == n) break;
                    n4 = string.charAt(i);
                    break;
                }
                case 34: 
                case 39: {
                    if (n2 == n4) {
                        n2 = 0;
                        break;
                    }
                    n2 = n4;
                    break;
                }
                case 63: {
                    if (n2 != 0) break;
                    stringBuffer.append('$');
                    stringBuffer.append(n3++);
                    continue block5;
                }
                default: {
                    if (n2 != 0 || !Character.isWhitespace((char)n4)) break;
                    ++i;
                    while (i < n && Character.isWhitespace(string.charAt(i))) {
                        ++i;
                    }
                    --i;
                    n4 = 32;
                }
            }
            stringBuffer.append((char)n4);
        }
        if (nArray != null) {
            nArray[0] = n3 - 1;
        }
        return stringBuffer.toString();
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        throw new UnsupportedOperationException("Procedure calls are not yet implemented");
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new UnsupportedOperationException("Procedure calls are not yet implemented");
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException("Procedure calls are not yet implemented");
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
        int[] nArray = new int[]{0};
        string = this.nativeSQL(string, nArray);
        SPIPreparedStatement sPIPreparedStatement = new SPIPreparedStatement(this, string, nArray[0]);
        Invocation.current().manageStatement(sPIPreparedStatement);
        return sPIPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (n != 1003) {
            throw new UnsupportedOperationException("TYPE_FORWARD_ONLY supported ResultSet type");
        }
        if (n2 != 1007) {
            throw new UnsupportedOperationException("CONCUR_READ_ONLY is the supported ResultSet concurrency");
        }
        return this.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (n3 != 2) {
            throw new UnsupportedOperationException("CLOSE_CURSORS_AT_COMMIT is the only supported ResultSet holdability");
        }
        return this.prepareStatement(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.rememberSavepoint(new SPIAnonymousSavepoint());
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        return this.rememberSavepoint(new SPINamedSavepoint(string));
    }

    static int getTypeForClass(Class clazz) {
        if (clazz.isArray() && !clazz.equals([B.class)) {
            return 2003;
        }
        Integer n = (Integer)s_sqlType2Class.get(clazz);
        if (n != null) {
            return n;
        }
        return 1111;
    }

    private Savepoint rememberSavepoint(SPISavepoint sPISavepoint) throws SQLException {
        Invocation invocation = Invocation.current();
        SPISavepoint sPISavepoint2 = invocation.getSavepoint();
        if (sPISavepoint2 == null) {
            invocation.setSavepoint(sPISavepoint);
        }
        return sPISavepoint;
    }

    private static void forgetSavepoint(SPISavepoint sPISavepoint) throws SQLException {
        Invocation invocation = Invocation.current();
        if (invocation.getSavepoint() == sPISavepoint) {
            invocation.setSavepoint(null);
        }
    }

    public int[] getVersionNumber() throws SQLException {
        if (this.VERSION_NUMBER != null) {
            return this.VERSION_NUMBER;
        }
        ResultSet resultSet = this.createStatement().executeQuery("SELECT version()");
        try {
            if (!resultSet.next()) {
                throw new SQLException("Cannot retrieve product version number");
            }
            String string = resultSet.getString(1);
            Pattern pattern = Pattern.compile("^PostgreSQL\\s+(\\d+)\\.(\\d+)\\.(\\d+)\\s+.*");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches() && matcher.groupCount() == 3) {
                this.VERSION_NUMBER = new int[3];
                this.VERSION_NUMBER[0] = Integer.parseInt(matcher.group(1));
                this.VERSION_NUMBER[1] = Integer.parseInt(matcher.group(2));
                this.VERSION_NUMBER[2] = Integer.parseInt(matcher.group(3));
                int[] nArray = this.VERSION_NUMBER;
                return nArray;
            }
            try {
                throw new SQLException("Unexpected product version string format: " + string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new SQLException("Error in product version string parsing: " + patternSyntaxException.getMessage());
            }
        }
        finally {
            resultSet.close();
        }
    }

    public int getSQLType(String string) {
        if (string == null) {
            return 1111;
        }
        for (int i = 0; i < JDBC3_TYPE_NAMES.length; ++i) {
            if (!string.equals(JDBC3_TYPE_NAMES[i])) continue;
            return JDBC_TYPE_NUMBERS[i];
        }
        return 1111;
    }

    public int getSQLType(int n) throws SQLException {
        return this.getSQLType(this.getPGType(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPGType(int n) throws SQLException {
        String string;
        block5: {
            string = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement("SELECT typname FROM pg_catalog.pg_type WHERE oid=?");
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string = resultSet.getString(1);
                    break block5;
                }
                throw new SQLException("Cannot find PG type with oid=" + n);
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        return string;
    }

    static {
        SPIConnection.addType(String.class, 12);
        SPIConnection.addType(Byte.class, -6);
        SPIConnection.addType(Short.class, 5);
        SPIConnection.addType(Integer.class, 4);
        SPIConnection.addType(Long.class, -5);
        SPIConnection.addType(Float.class, 6);
        SPIConnection.addType(Double.class, 8);
        SPIConnection.addType(BigDecimal.class, 3);
        SPIConnection.addType(BigInteger.class, 2);
        SPIConnection.addType(Boolean.class, 16);
        SPIConnection.addType(Blob.class, 2004);
        SPIConnection.addType(Clob.class, 2005);
        SPIConnection.addType(Date.class, 91);
        SPIConnection.addType(Time.class, 92);
        SPIConnection.addType(Timestamp.class, 93);
        SPIConnection.addType(java.util.Date.class, 93);
        SPIConnection.addType([B.class, -3);
        SPIConnection.addType(BitSet.class, -7);
        SPIConnection.addType(URL.class, 70);
        JDBC3_TYPE_NAMES = new String[]{"int2", "int4", "oid", "int8", "cash", "money", "numeric", "float4", "float8", "bpchar", "char", "char2", "char4", "char8", "char16", "varchar", "text", "name", "filename", "bytea", "bool", "bit", "date", "time", "timetz", "abstime", "timestamp", "timestamptz", "_bool", "_char", "_int2", "_int4", "_text", "_oid", "_varchar", "_int8", "_float4", "_float8", "_abstime", "_date", "_time", "_timestamp", "_numeric", "_bytea"};
        JDBC_TYPE_NUMBERS = new int[]{5, 4, 4, -5, 8, 8, 2, 7, 8, 1, 1, 1, 1, 1, 1, 12, 12, 12, 12, -2, -7, -7, 91, 92, 92, 93, 93, 93, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003};
    }
}

