/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class CommandReader
extends BufferedReader {
    private final Process m_process;
    private BufferedReader m_errorReader;

    private CommandReader(Process process, Reader reader) {
        super(reader);
        this.m_process = process;
    }

    public static CommandReader create(String[] stringArray, String[] stringArray2) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(stringArray, stringArray2);
        return new CommandReader(process, new InputStreamReader(process.getInputStream()));
    }

    public synchronized BufferedReader getErrorReader() {
        if (this.m_errorReader == null) {
            this.m_errorReader = new BufferedReader(new InputStreamReader(this.m_process.getErrorStream()));
        }
        return this.m_errorReader;
    }

    public void close() throws IOException {
        super.close();
        if (this.m_errorReader != null) {
            this.m_errorReader.close();
        }
    }

    public int getExitValue() throws IllegalThreadStateException {
        try {
            return this.m_process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            try {
                this.m_process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.m_process.exitValue();
        }
    }
}

