/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.internal.TupleTableSlot;
import org.postgresql.pljava.jdbc.SingleRowResultSet;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SingleRowReader
extends SingleRowResultSet {
    private final TupleDesc m_tupleDesc;
    private final Tuple m_tuple;

    public SingleRowReader(TupleTableSlot tupleTableSlot) throws SQLException {
        this.m_tupleDesc = tupleTableSlot.getTupleDesc();
        this.m_tuple = tupleTableSlot.getTuple();
    }

    protected Object getObjectValue(int n) throws SQLException {
        return this.m_tuple.getObject(this.getTupleDesc(), n);
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public void cancelRowUpdates() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public void deleteRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public void insertRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public void moveToInsertRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public void updateRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    protected final TupleDesc getTupleDesc() {
        return this.m_tupleDesc;
    }

    private static SQLException readOnlyException() {
        return new UnsupportedFeatureException("ResultSet is read-only");
    }
}

