/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BlobValue
extends InputStream
implements Blob {
    private final InputStream m_stream;
    private final long m_nBytes;
    private long m_streamPos;
    private long m_markPos;

    public BlobValue(byte[] byArray) {
        this(new ByteArrayInputStream(byArray), byArray.length);
    }

    public BlobValue(InputStream inputStream, long l) {
        this.m_stream = inputStream;
        this.m_nBytes = l;
        this.m_streamPos = 0L;
        this.m_markPos = 0L;
    }

    public long length() {
        return this.m_nBytes;
    }

    public InputStream getBinaryStream() {
        return this;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l < 0L || n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return new byte[0];
        }
        if (l + (long)n > this.m_nBytes) {
            throw new SQLException("Attempt to read beyond end of Blob data");
        }
        long l2 = l - this.m_streamPos;
        if (l2 < 0L) {
            throw new SQLException("Cannot position Blob stream backwards");
        }
        try {
            if (l2 > 0L) {
                this.skip(l2);
            }
            byte[] byArray = new byte[n];
            this.read(byArray);
            return byArray;
        }
        catch (IOException iOException) {
            throw new SQLException("Error reading Blob data: " + iOException.getMessage());
        }
    }

    public long position(byte[] byArray, long l) {
        throw new UnsupportedOperationException();
    }

    public long position(Blob blob, long l) {
        throw new UnsupportedOperationException();
    }

    public OutputStream setBinaryStream(long l) {
        throw new UnsupportedOperationException();
    }

    public int setBytes(long l, byte[] byArray) {
        throw new UnsupportedOperationException();
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public void truncate(long l) {
        throw new UnsupportedOperationException();
    }

    public int available() throws IOException {
        return this.m_stream.available();
    }

    public synchronized void mark(int n) {
        this.m_stream.mark(n);
        this.m_markPos = this.m_streamPos;
    }

    public boolean markSupported() {
        return this.m_stream.markSupported();
    }

    public synchronized int read() throws IOException {
        int n = this.m_stream.read();
        ++this.m_streamPos;
        return n;
    }

    public synchronized int read(byte[] byArray) throws IOException {
        int n = this.m_stream.read(byArray);
        this.m_streamPos += (long)n;
        return n;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.m_stream.read(byArray, n, n2);
        this.m_streamPos += (long)n3;
        return n3;
    }

    public synchronized long skip(long l) throws IOException {
        long l2 = this.m_stream.skip(l);
        this.m_streamPos += l2;
        return l2;
    }

    public synchronized void reset() throws IOException {
        this.m_stream.reset();
        this.m_streamPos = this.m_markPos;
    }
}

