/*
 * Group.java
 *
 * Created on 30 de julio de 2002, 17:31
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import java.sql.*;
import java.util.*;
import javax.swing.*;

/**
 *
 * @author  nestor
 */
public class Group extends DBObject {
    int user_list[] = null;
    Vector users = null;
    
    
    /** Creates a new instance of Group */
    public Group(DBObject owner, String _name) {
        super(owner);
        search(_name);
    }
    public Group(DBObject owner) {
        super(owner);
    }
    
    public boolean Drop(){
        boolean retorno = false;
        try{
            retorno = getConnection().executeUpdate("DROP GROUP " + getName()) > 0;
        } catch (SQLException e){
            JOptionPane.showMessageDialog(null, e.getMessage(), "Can't drop object", JOptionPane.ERROR_MESSAGE);
        }
        return retorno;
    }
    
    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer(50);
        retorno.append("DROP GROUP ");
        retorno.append(getName());
        retorno.append(";\n");
        return retorno.toString();
    }
    
    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer(50);
        retorno.append("CREATE GROUP ");
        retorno.append(getName());
        retorno.append(";\n");
        return retorno.toString();
    }
    
    /** Find the object asociated with the name.
     * @param _name Group Name to search.
     * @return true if the object was found
     */
    public boolean search(String _name) {
        boolean retorno = false;
        try{
            initialize();
            
            ResultSet rs = getConnection().getQueryGenerator().getGroups(_name);
            if((rs != null) && rs.next()){
                setName(rs.getString("group_name"));
                setUsers(rs.getArray("user_list"));
                retorno = true;
            }
            rs.close();
            rs.getStatement().close();
        } catch (SQLException e){
            e.printStackTrace();
        }
        return retorno;;
    }
    
    public void initialize(){
        super.initialize();
        user_list = null;
        users = null;
    }
    
    // ------ SET AND GET --------
    private int getUserIndex(User _user){
        int retorno = -1;
        for(int i=0; (i<users.size()) && (retorno == -1); i++){
            if(_user.getName().equals(((User) users.get(i)).getName())){
                retorno = i;
            }
        }
        return retorno;
    }
    private void verifyUsers(){
        if ((users == null) && (user_list != null)){
            users = new Vector();
            for(int i=0; i< user_list.length; i++){
                long uoid  = user_list[i];
                users.add(new User(this, uoid));
            }
        } else if(users == null) {
            users = new Vector();
        }
    }
    
    public Vector getUsers(){
        verifyUsers();
        return users;
    }
    
    public void addUser(User _user){
        verifyUsers();
        if ((_user != null) && getUserIndex(_user) < 0){
            users.add(_user);
        }
    }
    public void removeUser(User _user){
        verifyUsers();
        if (_user != null){
            int ind = getUserIndex(_user);
            if(ind >= 0){
                users.remove(ind);
            }
        }
    }
    /** refresh the data from database.
     */
    public void refresh() {
        search(getName());
    }
    
    // ------ PRIVATE METHODS --------
    private void setUsers(Array _users ){
        try{
            user_list = (int[]) _users.getArray();
        } catch (SQLException e){
            e.printStackTrace();
            user_list = null;
        }
    }
    
}
