/*
 * dataSource.java
 *
 * Created on 14 de septiembre de 2001, 11:05
 */

package pgclibrary.dataaccess;
import java.util.*;

/** It is a data source that permits implements
 * tables, and reports
 * Is a abstract class that makes an interface for abstraction.
 *
 * @author NMarsollier
 * @version 1.0
 */
public abstract class dataSource extends java.lang.Object {
    public static final int MAX_COLUMN_SIZE = 100;
    public static final int MIN_COLUMN_SIZE = 7;
    public static final int DEFAULT_COLUMN_SIZE = 12;
    
    
    private ArrayList columnNames = new ArrayList();
    private int rowNum=0;
    private boolean filtered = false;
    private int rec_begin;
    private int rec_end;
    
    /** Creates new dataSource */
    public dataSource() {
    }
    
    /** Close and clean the data stored. */
    public abstract void close();
    
    /** Se mueve el puntero de datos a la primer fila de informacion.
     */
    public abstract void goTop();
    
    /** Moves the pointer to the first row.
     *
     * @param _record Record number
     */
    public void moveToRecord(int _record) {
        if(_record < getRowNum()){
            goTop();
        }
        while(getRowNum() < _record){
            next();
        }
    }
    
    /** Moves the record pointer to the
     * next record.
     *
     * @return Return flase if no record left.
     *
     */
    public abstract boolean next();
    
    /** Determine if the last row has arrived.
     *
     * @return Return true if it's the last row.
     */
    public abstract boolean eof();
    
    /** Return the column count.
     * @return Column Count
     */
    public abstract int getColumnCount();
    
    
    /** Retrieve the column size for the Specific column.
     * The column size is between MAX_COLUMN_SIZE and
     * MIN_COLUMN_SIZE.
     * If no column size defined for the specific column
     * retrieve DEFAULT_COLUMN_SIZE.
     * @param _col Column
     * @return Column size.
     */
    public int getColumnSize(String _col){
        if(_col != null){
            return getColumnSize(columnNames.indexOf(_col.toUpperCase())+1);
        } else {
            return 10;
        }
    }
    /** Same as avobe.
     * @param _col Column number.
     * @return Size.
     */
    public abstract int getColumnSize(int _col);
    
    protected int validateColumnSize(int _size){
        if(_size > MAX_COLUMN_SIZE){
            _size = MAX_COLUMN_SIZE;
        } else if(_size < 1){
            _size = DEFAULT_COLUMN_SIZE;
        } else if(_size < MIN_COLUMN_SIZE){
            _size = MIN_COLUMN_SIZE;
        }
        return _size;
    }
    
    /** Retrieve an String with the value of the specified column.
     * @param _col Column number
     * @return Valued stored.
     */
    public abstract String getElementAt(int _col);
    
    /** Return the total record count without filters.
     * @return Row count.
     */
    public abstract int getRowCount();
    
    /** Filters the data source to the specified
     * range of record numbers.
     * Then only we can navigate around this
     * records.
     * @param _rec_begin From record.
     * @param _rec_end To record.
     */
    public void setDataFilterRecord(int _rec_begin, int _rec_end){
        filtered = true;
        rec_begin = _rec_begin;
        rec_end = _rec_end;
    }
    
    /** Return the first record number.
     * Its the 'filter from' record number in case of filter definition.
     * @return First record available.
     */
    public int getRowBegin(){
        return rec_begin;
    }
    /** Return the last record number.
     * Its the 'filter to' record number in case of filter definition.
     * @return Last record available
     */
    public int getRowEnd(){
        return rec_end;
    }
    /** Clear the filter definition.
     */
    public void clearFilters(){
        if(isFiltered()){
            filtered = false;
        }
    }
    
    /** Retrieve true if its datasource has an filtered defined.
     * @return true if it's filtered.
     */
    public boolean isFiltered(){
        return filtered;
    }
    
    /** Retieve the current row position.
     * @return row number.
     */
    public int getRowNum(){
        return rowNum;
    }
    /** Sets and moves the row number pointer.
     * @param _rowNum Row number to move.
     */
    protected void setRowNum(int _rowNum){
        if(_rowNum < 0){
            _rowNum = 0;
        }
        rowNum = _rowNum;
    }
    
    /** Retrieve the element value from the specific column name.
     * @param _col Column name
     * @return Element
     * @see #getElementAt(int)
     */
    public String getElementAt(String _col){
        if(_col != null){
            return getElementAt(columnNames.indexOf(_col.toUpperCase())+1);
        } else {
            return "null";
        }
    }
    
    /** Return the int value for the specific column.
     * @param _col Column name
     * @return int value of the element.
     */
    public int getIntAt(String _col) {
        int retorno = 0;
        try {
            retorno = Integer.parseInt(getElementAt(_col));
        } catch (Exception e) {}
        return retorno;
    }
    /** Return the element int value of the specified column.
     * @param _col Column number
     * @return int value
     */
    public int getIntAt(int _col) {
        int retorno = 0;
        try {
            retorno = Integer.parseInt(getElementAt(_col));
        } catch (Exception e) {}
        return retorno;
    }
    
    /** Retrieve the double value stored at specific column.
     * @param _col Column name
     * @return Value stored.
     */
    public double getDoubleAt(String _col) {
        double retorno = 0;
        try {
            retorno = Double.parseDouble(getElementAt(_col));
        } catch (Exception e) {}
        return retorno;
    }
    /** Retrieve the double value stored at specific column.
     * @param _col Column number
     * @return value stored.
     */
    public double getDoubleAt(int _col) {
        double retorno = 0;
        try {
            retorno = Double.parseDouble(getElementAt(_col));
        } catch (Exception e) {}
        return retorno;
    }
    
    /** Sets the column names.
     * In some implemented clases it has no efect.
     *
     * @param _columnNames Column names
     */
    public void setColumnNames(ArrayList _columnNames){
        columnNames.clear();
        if(_columnNames!=null){
            for(int i=0; i<_columnNames.size(); i++){
                columnNames.add(_columnNames.get(i));
            }
        }
    }
    /** Retieves an Column names array list.
     * @return Column names.
     */
    public ArrayList getColumnNames(){
        return columnNames;
    }
    /** Adds the next column name.
     *
     *
     * @param _columnName Column name
     */
    public void addColumnName(String _columnName){
        if((_columnName != null) && (columnNames.indexOf(_columnName)<0)){
            columnNames.add(_columnName.toUpperCase());
        }
    }
    /** Deletes a column name from the names column.
     * @param _columnName Column name to delete.
     */
    public void removeColumnName(String _columnName){
        if(_columnName != null){
            columnNames.remove(_columnName);
        }
    }
    
    /** Find a record in the values.
     * And makes this record as current record.
     * Even it begin the search form the first record.
     *
     * @param _column Column to search.
     * @param _value Value to search.
     * @return True if found.
     */
    public boolean find(int _column, String _value){
        boolean retorno = false;
        goTop();
        while(!retorno && next()){
            retorno = getElementAt(_column).equals(_value);
        }
        return retorno;
    }
    
}
