/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.ResultSet;
import java.sql.SQLException;
import pgclibrary.objects.AttributeType;
import pgclibrary.objects.DBObject;

public class TableColumn
extends DBObject {
    private int col_number = 0;
    private int size = 0;
    private boolean allow_nulls = false;
    private AttributeType column_type = null;
    private String default_value = new String();
    private String description = null;

    public TableColumn(DBObject dBObject, String string) {
        super(dBObject);
        this.search(string);
    }

    public String getDeleteSQL() {
        return new String();
    }

    public String getInsertSQL() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(this.getName());
        stringBuffer.append(" ");
        if (this.getColumnType() != null) {
            stringBuffer.append(this.getColumnType().getName().toUpperCase());
            stringBuffer.append(" ");
            if (this.getColumnType().getSize() < 0) {
                stringBuffer.append("(");
                stringBuffer.append(this.getSize());
                stringBuffer.append(") ");
            }
        }
        if (!this.allowNulls()) {
            stringBuffer.append("NOT NULL ");
        }
        if (this.getDefaultValue() != null && this.getDefaultValue().trim().length() > 0) {
            stringBuffer.append("DEFAULT ");
            stringBuffer.append(this.getDefaultValue());
        }
        return stringBuffer.toString();
    }

    public boolean search(String string) {
        boolean bl = false;
        try {
            this.initialize();
            ResultSet resultSet = this.getConnection().getQueryGenerator().getTableColumn(this.getOwner().getName(), string);
            if (resultSet != null && resultSet.next()) {
                this.setName(resultSet.getString("column_name"));
                this.setColumnNumber(resultSet.getInt("column_number"));
                this.setSize(resultSet.getInt("column_size"));
                this.setAllowNulls(!resultSet.getBoolean("column_notnull"));
                this.setColumnType(AttributeType.searchObject(resultSet.getString("type_name")));
                this.setDefaultValue(resultSet.getString("default_value"));
                bl = true;
            }
            resultSet.close();
            resultSet.getStatement().close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return bl;
    }

    public void initialize() {
        super.initialize();
        this.col_number = 0;
        this.size = 0;
        this.allow_nulls = false;
        this.column_type = null;
        this.default_value = new String();
        this.description = null;
    }

    public String getDefaultValue() {
        return this.default_value;
    }

    public int getColumnNumber() {
        return this.col_number;
    }

    public int getSize() {
        if (this.size > 0) {
            return this.size;
        }
        return this.column_type.getSize();
    }

    public boolean allowNulls() {
        return this.allow_nulls;
    }

    private void setColumnType(AttributeType attributeType) {
        this.column_type = attributeType;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.getConnection().getQueryGenerator().getColumnDescription(this.getOwner().getName(), this.getName());
        }
        return this.description;
    }

    public AttributeType getColumnType() {
        return this.column_type;
    }

    public void refresh() {
        this.search(this.getName());
    }

    protected String getCommentSQL() {
        String string = new String();
        if (this.getDescription().length() > 0) {
            string = "COMMENT ON COLUMN " + this.getOwner().getName() + "." + this.getName() + " IS '" + this.getDescription() + "'; \n";
        }
        return string;
    }

    private void setDefaultValue(String string) {
        this.default_value = string != null ? string : new String();
    }

    private void setColumnNumber(int n) {
        this.col_number = n;
    }

    private void setSize(int n) {
        this.size = n;
    }

    private void setAllowNulls(boolean bl) {
        this.allow_nulls = bl;
    }

    private void setDescription(String string) {
        this.description = string != null ? string : new String();
    }
}

