/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.dataaccess;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import pgclibrary.dataaccess.MainConnection;
import pgclibrary.dataaccess.dataSource;

public class dataSourceResultSet
extends dataSource {
    SimpleDateFormat espFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
    String query = new String();
    MainConnection connection = null;
    private Statement stat = null;
    private ResultSet rs = null;
    private boolean eof = false;
    private int row_count = -1;

    public dataSourceResultSet() {
    }

    public void close() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.stat.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public dataSourceResultSet(MainConnection mainConnection, String string) {
        this.connection = mainConnection;
        this.query = string;
    }

    public void setResultSet(MainConnection mainConnection, String string) {
        this.connection = mainConnection;
        this.query = string;
    }

    public void setColumnNames(ArrayList arrayList) {
    }

    public void removeColumnName(String string) {
    }

    public void addColumnName(String string) {
    }

    public void goTop() {
        if (this.rs == null) {
            this.requeryInternal();
        }
        try {
            this.rs.beforeFirst();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setRowNum(0);
        this.eof = false;
    }

    public boolean next() {
        if (this.rs == null) {
            this.requeryInternal();
        }
        boolean bl = false;
        if (this.rs != null) {
            try {
                bl = this.rs.next();
                this.setRowNum(this.getRowNum() + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            this.eof = true;
        }
        return bl;
    }

    public boolean eof() {
        if (this.rs == null) {
            this.requeryInternal();
        }
        return this.eof;
    }

    public String getElementAt(int n) {
        String string = new String();
        if (this.rs == null) {
            this.requeryInternal();
        }
        try {
            ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
            switch (resultSetMetaData.getColumnType(n)) {
                case 91: 
                case 93: {
                    Timestamp timestamp = this.rs.getTimestamp(n);
                    if (timestamp != null) {
                        string = this.espFormat.format(timestamp);
                    }
                    break;
                }
                default: {
                    string = this.rs.getString(n);
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string;
    }

    public int getColumnCount() {
        if (this.rs == null) {
            this.requeryInternal();
        }
        return this.getColumnNames().size();
    }

    public int getColumnSize(int n) {
        int n2 = 10;
        try {
            ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
            n2 = resultSetMetaData.getColumnDisplaySize(n);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.validateColumnSize(n2);
    }

    public int getRowCount() {
        if (this.rs == null) {
            this.requeryInternal();
        }
        if (this.row_count == -1) {
            String string = "SELECT COUNT(*) AS CANT FROM ( " + this.query + ") as tmp ";
            try {
                MainConnection mainConnection = new MainConnection(this.connection);
                ResultSet resultSet = mainConnection.executeQuery(string);
                if (resultSet != null && resultSet.next()) {
                    this.row_count = resultSet.getInt("CANT");
                }
                resultSet.close();
                mainConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.row_count;
    }

    public void setDataFilterRecord(int n, int n2) {
        super.setDataFilterRecord(n, n2);
        this.requeryInternal();
    }

    public void requery() throws SQLException {
        this.close();
        if (this.isFiltered()) {
            String string = this.query + " limit " + String.valueOf(this.getRowEnd() - this.getRowBegin());
            string = string + " offset " + String.valueOf(this.getRowBegin());
            this.stat = this.connection.getStatement();
            this.rs = this.stat.executeQuery(string);
        } else {
            this.stat = this.connection.getStatement();
            this.rs = this.stat.executeQuery(this.query);
        }
        this.row_count = -1;
        this.setAllColumnNames();
    }

    private void requeryInternal() {
        try {
            this.requery();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void setAllColumnNames() {
        try {
            ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
            super.getColumnNames().clear();
            int n = resultSetMetaData.getColumnCount();
            int n2 = 0;
            while (n2 < n) {
                super.addColumnName(resultSetMetaData.getColumnName(n2 + 1));
                ++n2;
            }
            this.goTop();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

