/*
 * Decompiled with CFR 0.152.
 */
package frames;

import frames.ConnectDialogListener;
import frames.PrincipalFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import pgclibrary.dataaccess.MainConnection;
import pgclibrary.utilities.Utilities;

public class ConnectDialog
extends JDialog {
    PrincipalFrame frame = null;
    JTextField host = new JTextField(20);
    JTextField port = new JTextField(20);
    JTextField database = new JTextField(20);
    JTextField username = new JTextField(20);
    JPasswordField password = new JPasswordField(20);

    public ConnectDialog(PrincipalFrame principalFrame) {
        super((Frame)principalFrame, "Connect to the database");
        this.frame = principalFrame;
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConnectDialog.this.close();
            }
        });
        this.getContentPane().add(this.getContents(), "Center");
        this.getContentPane().add(this.getButtons(), "South");
        this.setLocationRelativeTo(this.frame);
        this.setModal(true);
        this.pack();
    }

    private Component getContents() {
        this.port.setText(this.frame.getSystemProperties().getProperty("PORT"));
        this.host.setText(this.frame.getSystemProperties().getProperty("HOST"));
        this.database.setText(this.frame.getSystemProperties().getProperty("DATABASE"));
        this.username.setText(this.frame.getSystemProperties().getProperty("USERNAME"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JLabel("Host: "));
        this.host.setMaximumSize(this.host.getPreferredSize());
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.host);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JLabel("Port: "));
        this.port.setMaximumSize(this.port.getPreferredSize());
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.port);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JLabel("Database: "));
        this.database.setMaximumSize(this.database.getPreferredSize());
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.database);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JLabel("User Name: "));
        this.username.setMaximumSize(this.username.getPreferredSize());
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.username);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JLabel("Password: "));
        this.password.setMaximumSize(this.password.getPreferredSize());
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.password);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private Component getButtons() {
        ConnectDialogListener connectDialogListener = new ConnectDialogListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        JButton jButton = new JButton("Connect");
        jButton.setActionCommand("connect");
        jButton.addActionListener(connectDialogListener);
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(5));
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("cancel");
        jButton2.addActionListener(connectDialogListener);
        jPanel.add(jButton2);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private String getURI() {
        return "jdbc:postgresql://" + this.host.getText().trim() + ":" + this.port.getText().trim() + "/" + this.database.getText().trim();
    }

    protected void connect() {
        MainConnection mainConnection = new MainConnection("org.postgresql.Driver", this.getURI(), this.username.getText().trim(), new String(this.password.getPassword()).trim());
        if (mainConnection.isConnected()) {
            this.frame.setDatabase(mainConnection);
            this.frame.getSystemProperties().setProperty("HOST", this.host.getText().trim());
            this.frame.getSystemProperties().setProperty("PORT", this.port.getText().trim());
            this.frame.getSystemProperties().setProperty("DATABASE", this.database.getText().trim());
            this.frame.getSystemProperties().setProperty("USERNAME", this.username.getText().trim());
            this.frame.refreshValidation();
            this.close();
        } else {
            JOptionPane.showMessageDialog(this, "The database is not accesible.\n" + Utilities.parseError(mainConnection.getError()), "Not connected", 0);
        }
    }

    protected void close() {
        this.dispose();
    }
}

