/*
 * Decompiled with CFR 0.152.
 */
package components.table;

import components.SQLTable;
import components.SQLTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pgclibrary.dataaccess.dataSource;
import pgclibrary.dataaccess.dataSourceVector;
import pgclibrary.objects.Table;
import pgclibrary.objects.TableForeignKey;
import pgclibrary.utilities.Utilities;

public class ForeignKeyPanel
extends JPanel {
    private Table table = null;
    private SQLTable data_table = new SQLTable();

    public ForeignKeyPanel() {
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        SQLTableModel sQLTableModel = new SQLTableModel(this.data_table);
        this.data_table.setModel(sQLTableModel);
        this.add((Component)new JScrollPane(this.data_table), "Center");
    }

    public void refresh() {
        ((SQLTableModel)this.data_table.getModel()).setDataSource(this.getForeignKeyTable());
        this.repaint();
    }

    public void refresh(Table table) {
        this.table = table;
        this.refresh();
    }

    public Table getTable() {
        return this.table;
    }

    public void newColumn() {
    }

    public void editColumn() {
    }

    public void deleteColumn() {
    }

    public dataSource getForeignKeyTable() {
        dataSourceVector dataSourceVector2 = new dataSourceVector();
        dataSourceVector2.addColumnName("Name");
        dataSourceVector2.addColumnName("Ref. Table");
        dataSourceVector2.addColumnName("Enabled");
        dataSourceVector2.addColumnName("S.Columns");
        dataSourceVector2.addColumnName("Ref.Columns");
        dataSourceVector2.addColumnName("On Update");
        dataSourceVector2.addColumnName("On Delete");
        dataSourceVector2.addColumnName("Deferrable");
        dataSourceVector2.addColumnSize(20);
        dataSourceVector2.addColumnSize(20);
        dataSourceVector2.addColumnSize(10);
        dataSourceVector2.addColumnSize(25);
        dataSourceVector2.addColumnSize(25);
        dataSourceVector2.addColumnSize(10);
        dataSourceVector2.addColumnSize(10);
        dataSourceVector2.addColumnSize(10);
        if (this.table != null) {
            Vector vector = this.table.getForeignKeys();
            int n = 0;
            while (n < vector.size()) {
                TableForeignKey tableForeignKey = (TableForeignKey)vector.get(n);
                Vector<String> vector2 = new Vector<String>();
                vector2.add(tableForeignKey.getName());
                vector2.add(this.table.getName() + " --> " + tableForeignKey.getTableName());
                vector2.add(Utilities.formatBoolean(tableForeignKey.isEnabled()));
                vector2.add(tableForeignKey.getSourceColumns());
                vector2.add(tableForeignKey.getDestColumns());
                vector2.add(tableForeignKey.getOnUpdate());
                vector2.add(tableForeignKey.getOnDelete());
                vector2.add(Utilities.formatBoolean(tableForeignKey.isDeferrable()));
                dataSourceVector2.addElement(vector2);
                ++n;
            }
        }
        return dataSourceVector2;
    }
}

