/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.TreeControlCellRenderer;
import components.TreeControlModel;
import components.treeObjects.RootElement;
import components.treeObjects.TreeInfo;
import frames.PrincipalFrame;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeSelectionModel;
import pgclibrary.objects.Database;

public class TreeControl
extends JTree {
    private Database database = null;
    private PrincipalFrame frame = null;

    public TreeControl(PrincipalFrame principalFrame) {
        super(new TreeControlModel(new RootElement(principalFrame.getDatabase())));
        this.frame = principalFrame;
        this.database = principalFrame.getDatabase();
        this.setEditable(false);
        this.setScrollsOnExpand(true);
        this.setShowsRootHandles(true);
        this.putClientProperty("JTree.lineStyle", "Angled");
        TreeSelectionModel treeSelectionModel = this.getSelectionModel();
        this.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this.setCellRenderer(new TreeControlCellRenderer());
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (TreeControl.this.getLastSelectedPathComponent() != null) {
                    TreeInfo treeInfo = (TreeInfo)TreeControl.this.getLastSelectedPathComponent();
                    TreeControl.this.frame.updateSelectedObject(treeInfo);
                }
            }
        });
    }

    public TreeInfo getRoot() {
        return (TreeInfo)this.getModel().getRoot();
    }

    public void refreshTree() {
        this.collapseRow(0);
        this.getRoot().refreshProperties();
        TreeControlModel treeControlModel = (TreeControlModel)this.getModel();
        treeControlModel.fireTreeStructureChanged();
        this.expandRow(0);
    }
}

