# $NetBSD: options.mk,v 1.1 2025/05/25 18:18:07 vins Exp $

PKG_OPTIONS_VAR=	PKG_OPTIONS.worker
PKG_SUPPORTED_OPTIONS=	dbus lua inotify ssl xft2
PKG_SUGGESTED_OPTIONS=	dbus ssl xft2

.include "../../mk/bsd.options.mk"

.if !empty(PKG_OPTIONS:Mxft2)
CONFIGURE_ARGS+=	--enable-xft
.include	"../../x11/libXft/buildlink3.mk"
.else
CONFIGURE_ARGS+=	--disable-xft
.endif

.if !empty(PKG_OPTIONS:Mlua)
CONFIGURE_ARGS+=	--enable-lua
.include	"../../lang/lua/buildlink3.mk"
.else
CONFIGURE_ARGS+=	--disable-lua
.endif

.if !empty(PKG_OPTIONS:Mdbus)
CONFIGURE_ARGS+=        --with-dbus
.  include "../../sysutils/dbus/buildlink3.mk"
.else
CONFIGURE_ARGS+=        --without-dbus
.endif

.if !empty(PKG_OPTIONS:Mssl)
.include	"../../security/openssl/buildlink3.mk"
.endif

.if !empty(PKG_OPTIONS:Minotify)
CONFIGURE_ARGS+=	--enable-inotify
.  include	"../../devel/libinotify/buildlink3.mk"
.else
CONFIGURE_ARGS+=	--disable-inotify
.endif
