/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class MetalToggleButtonUI
extends BasicToggleButtonUI {
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;

    public static ComponentUI createUI(JComponent component) {
        return new MetalToggleButtonUI();
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.focusColor = defaults.getColor(this.getPropertyPrefix() + "focus");
        this.selectColor = defaults.getColor(this.getPropertyPrefix() + "select");
        this.disabledTextColor = defaults.getColor(this.getPropertyPrefix() + "disabledText");
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled() && b.isOpaque()) {
            Color saved = g.getColor();
            Rectangle bounds = SwingUtilities.getLocalBounds(b);
            g.setColor(this.selectColor);
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g.setColor(saved);
        }
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        Font savedFont = g.getFont();
        Color savedColor = g.getColor();
        g.setFont(c.getFont());
        if (c.isEnabled()) {
            g.setColor(c.getForeground());
        } else {
            g.setColor(this.disabledTextColor);
        }
        FontMetrics fm = g.getFontMetrics(c.getFont());
        int ascent = fm.getAscent();
        g.drawString(text, textRect.x, textRect.y + ascent);
        g.setFont(savedFont);
        g.setColor(savedColor);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!b.hasFocus()) {
            return;
        }
        Color saved = g.getColor();
        g.setColor(this.focusColor);
        Rectangle fr = iconRect.union(textRect);
        g.drawRect(fr.x - 1, fr.y - 1, fr.width + 1, fr.height + 1);
        g.setColor(saved);
    }
}

