/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;

public class BasicAttribute
implements Attribute {
    private static final long serialVersionUID = 6743528196119291326L;
    protected String attrID;
    protected boolean ordered;
    protected transient Vector values;

    public void add(int index, Object val) {
        if (!this.ordered && this.contains(val)) {
            throw new IllegalStateException("value already in attribute");
        }
        this.values.add(index, val);
    }

    public boolean add(Object val) {
        if (!this.ordered && this.contains(val)) {
            throw new IllegalStateException("value already in attribute");
        }
        return this.values.add(val);
    }

    public void clear() {
        this.values.clear();
    }

    public Object clone() {
        BasicAttribute c = new BasicAttribute();
        c.attrID = this.attrID;
        c.ordered = this.ordered;
        c.values = (Vector)this.values.clone();
        return c;
    }

    public boolean contains(Object val) {
        int i = 0;
        while (i < this.values.size()) {
            if (this.equals(val, this.values.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BasicAttribute)) {
            return false;
        }
        BasicAttribute b = (BasicAttribute)obj;
        if (this.ordered != b.ordered || !this.attrID.equals(b.attrID) || this.values.size() != b.values.size()) {
            return false;
        }
        int i = 0;
        while (i < this.values.size()) {
            boolean ok = false;
            if (this.ordered) {
                ok = this.equals(this.values.get(i), b.values.get(i));
            } else {
                int j = 0;
                while (j < b.values.size()) {
                    if (this.equals(this.values.get(i), b.values.get(j))) {
                        ok = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!ok) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object get() throws NamingException {
        if (this.values.size() == 0) {
            throw new NoSuchElementException("no values");
        }
        return this.get(0);
    }

    public Object get(int index) throws NamingException {
        return this.values.get(index);
    }

    public NamingEnumeration getAll() throws NamingException {
        return new BasicAttributeEnumeration();
    }

    public DirContext getAttributeDefinition() throws OperationNotSupportedException, NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getAttributeSyntaxDefinition() throws OperationNotSupportedException, NamingException {
        throw new OperationNotSupportedException();
    }

    public String getID() {
        return this.attrID;
    }

    public int hashCode() {
        int val = this.attrID.hashCode();
        int i = 0;
        while (i < this.values.size()) {
            Object o = this.values.get(i);
            if (o != null) {
                if (o instanceof Object[]) {
                    Object[] a = (Object[])o;
                    int j = 0;
                    while (j < a.length) {
                        val += a[j].hashCode();
                        ++j;
                    }
                } else {
                    val += o.hashCode();
                }
            }
            ++i;
        }
        return val;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public Object remove(int index) {
        return this.values.remove(index);
    }

    public boolean remove(Object val) {
        int i = 0;
        while (i < this.values.size()) {
            if (this.equals(val, this.values.get(i))) {
                this.values.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object set(int index, Object val) {
        if (!this.ordered && this.contains(val)) {
            throw new IllegalStateException("value already in attribute");
        }
        return this.values.set(index, val);
    }

    public int size() {
        return this.values.size();
    }

    public String toString() {
        String r = this.attrID;
        int i = 0;
        while (i < this.values.size()) {
            r = r + ';' + this.values.get(i).toString();
            ++i;
        }
        return r;
    }

    private final boolean equals(Object one, Object two) {
        if (one == null) {
            boolean bl = false;
            if (two == null) {
                bl = true;
            }
            return bl;
        }
        if (one instanceof Object[]) {
            if (!(two instanceof Object[])) {
                return false;
            }
            Object[] aone = (Object[])one;
            Object[] atwo = (Object[])two;
            if (aone.length != atwo.length) {
                return false;
            }
            int i = 0;
            while (i < aone.length) {
                if (!aone[i].equals(atwo[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return one.equals(two);
    }

    private BasicAttribute() {
    }

    public BasicAttribute(String id) {
        this(id, false);
    }

    public BasicAttribute(String id, boolean ordered) {
        this.attrID = id;
        this.ordered = ordered;
        this.values = new Vector();
    }

    public BasicAttribute(String id, Object value) {
        this(id, value, false);
    }

    public BasicAttribute(String id, Object value, boolean ordered) {
        this.attrID = id;
        this.ordered = ordered;
        this.values = new Vector();
        this.values.add(value);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BasicAttributeEnumeration
    implements NamingEnumeration {
        int where;

        public void close() throws NamingException {
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public boolean hasMoreElements() {
            boolean bl = false;
            if (this.where < BasicAttribute.this.values.size()) {
                bl = true;
            }
            return bl;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.where + 1 >= BasicAttribute.this.values.size()) {
                throw new NoSuchElementException("no more elements");
            }
            ++this.where;
            return BasicAttribute.this.values.get(this.where);
        }

        private final /* synthetic */ void this() {
            this.where = -1;
        }

        public BasicAttributeEnumeration() {
            this.this();
        }
    }
}

