require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&PMAP_H)) {
    eval 'sub PMAP_H () {1;}' unless defined(&PMAP_H);
    require 'sys/atomic.ph';
    require 'uvm/uvm_page.ph';
    require 'machine/pte.ph';
    require 'machine/mtpr.ph';
    require 'machine/pcb.ph';
    eval 'sub LTOHPS () {( &PGSHIFT -  &VAX_PGSHIFT);}' unless defined(&LTOHPS);
    eval 'sub LTOHPN () {(1<<  &LTOHPS);}' unless defined(&LTOHPN);
    eval 'sub MAPVIRT {
        my($ptr, $count) = @_;
	    eval q($ptr =  &virtual_avail;  &virtual_avail += ($count) *  &VAX_NBPG;);
    }' unless defined(&MAPVIRT);
    eval 'sub MAPPHYS {
        my($ptr, $count, $perm) = @_;
	    eval q($ptr =  &avail_start +  &KERNBASE;  &avail_start += ($count) *  &VAX_NBPG;);
    }' unless defined(&MAPPHYS);
    eval 'sub PMAP_VTOPHYS {
        my($va) = @_;
	    eval q((($va) & ~ &KERNBASE));
    }' unless defined(&PMAP_VTOPHYS);
    eval 'sub PMAP_MAP_POOLPAGE {
        my($pa) = @_;
	    eval q((($pa) |  &KERNBASE));
    }' unless defined(&PMAP_MAP_POOLPAGE);
    eval 'sub PMAP_UNMAP_POOLPAGE {
        my($va) = @_;
	    eval q((($va) & ~ &KERNBASE));
    }' unless defined(&PMAP_UNMAP_POOLPAGE);
    eval 'sub PMAP_STEAL_MEMORY () {1;}' unless defined(&PMAP_STEAL_MEMORY);
    eval 'sub pmap_pg_to_pv {
        my($pg) = @_;
	    eval q({  &pv_table + ( &VM_PAGE_TO_PHYS($pg) >>  &PGSHIFT); });
    }' unless defined(&pmap_pg_to_pv);
    eval 'sub pmap_is_referenced {
        my($pg) = @_;
	    eval q({  &const \'struct pv_entry\' *  &const  &pv =  &pmap_pg_to_pv($pg); ( ($pv->{pv_attr}) &  &PG_V) != 0; });
    }' unless defined(&pmap_is_referenced);
    eval 'sub pmap_page_protect {
        my($pg,$prot) = @_;
	    eval q({ \'struct pv_entry\' *  &const  &pv =  &pmap_pg_to_pv($pg);  &if ( ($pv->{pv_pmap}) !=  &NULL ||  ($pv->{pv_next}) !=  &NULL)  &pmap_page_protect_long( &pv, $prot); });
    }' unless defined(&pmap_page_protect);
    eval 'sub pmap_protect {
        my($pmap,$start,$end,$prot) = @_;
	    eval q({  &if ( ($pmap->{pm_p0lr}) != 0||  ($pmap->{pm_p1lr}) != 0x200000 || ($start &  &KERNBASE) != 0)  &pmap_protect_long($pmap, $start, $end, $prot); });
    }' unless defined(&pmap_protect);
    eval 'sub pmap_remove_all {
        my($pmap) = @_;
	    eval q({  &false; });
    }' unless defined(&pmap_remove_all);
    eval 'sub pmap_phys_address {
        my($phys) = @_;
	    eval q((($phys) <<  &PGSHIFT));
    }' unless defined(&pmap_phys_address);
    eval 'sub pmap_copy {
        my($a,$b,$c,$d,$e) = @_;
	    eval q();
    }' unless defined(&pmap_copy);
    eval 'sub pmap_update {
        my($pmap) = @_;
	    eval q();
    }' unless defined(&pmap_update);
    eval 'sub pmap_remove {
        my($pmap, $start, $end) = @_;
	    eval q( &pmap_protect($pmap, $start, $end, 0));
    }' unless defined(&pmap_remove);
    eval 'sub pmap_resident_count {
        my($pmap) = @_;
	    eval q((($pmap)-> ($pm_stats->{resident_count})));
    }' unless defined(&pmap_resident_count);
    eval 'sub pmap_wired_count {
        my($pmap) = @_;
	    eval q((($pmap)-> ($pm_stats->{wired_count})));
    }' unless defined(&pmap_wired_count);
    eval 'sub pmap_reference {
        my($pmap) = @_;
	    eval q( &atomic_inc_uint(($pmap)-> &pm_count));
    }' unless defined(&pmap_reference);
    eval 'sub pmap_copy_page {
        my($src, $dst) = @_;
	    eval q( &__asm(\\"addl3 $0x80000000,%0,%%r0;\\" \\"addl3 $0x80000000,%1,%%r1;\\" \\"movc3 $4096,(%%r0),(%%r1)\\" :: \\"r\\"($src), \\"r\\"($dst) : \\"r0\\",\\"r1\\",\\"r2\\",\\"r3\\",\\"r4\\",\\"r5\\"););
    }' unless defined(&pmap_copy_page);
    eval 'sub pmap_zero_page {
        my($phys) = @_;
	    eval q( &__asm(\\"addl3 $0x80000000,%0,%%r0;\\" \\"movc5 $0,(%%r0),$0,$4096,(%%r0)\\" :: \\"r\\"($phys) : \\"r0\\",\\"r1\\",\\"r2\\",\\"r3\\",\\"r4\\",\\"r5\\"););
    }' unless defined(&pmap_zero_page);
    if(0) {
	eval 'sub __HAVE_VM_PAGE_MD () {1;}' unless defined(&__HAVE_VM_PAGE_MD);
	eval 'sub VM_MDPAGE_INIT {
	    my($pg) = @_;
    	    eval q((($pg)-> ($mdpage->{md_attrs}) = 0));
	}' unless defined(&VM_MDPAGE_INIT);
    }
}
1;
