/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.fastq;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FastqNamePattern {
    CASAVA_13("(.* )?([^:]+:[0-9]+:[0-9]+:[0-9]+:[0-9]+#[A-Z0-9]+).*", "$2"),
    CASAVA_18("(.* )?([^:]+:[0-9]+:[A-Z0-9]+:[0-9]+:[0-9]+:[0-9]+:[0-9]+).*", "$2");

    private Pattern pattern;
    private String replacement;

    private FastqNamePattern(String patternStr, String replacement) {
        this.pattern = Pattern.compile(patternStr);
        this.replacement = replacement;
    }

    public boolean match(String str) {
        return this.pattern.matcher(str).find();
    }

    public String canonicalizeOne(String str) {
        Matcher matcher = this.pattern.matcher(str);
        if (!matcher.find()) {
            return null;
        }
        return matcher.replaceAll(this.replacement);
    }

    public static String canonicalize(String str) {
        for (FastqNamePattern fnp : FastqNamePattern.values()) {
            String canon = fnp.canonicalizeOne(str);
            if (canon == null) continue;
            return canon;
        }
        return null;
    }
}

