/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.common.CRAMVersion;
import java.util.Arrays;
import java.util.Objects;

public final class CramHeader {
    public static final byte[] MAGIC = "CRAM".getBytes();
    public static final int CRAM_MAGIC_LENGTH = MAGIC.length;
    public static final int CRAM_ID_LENGTH = 20;
    public static final int CRAM_VERSION_LENGTH = 2;
    public static final int CRAM_HEADER_LENGTH = CRAM_MAGIC_LENGTH + 2 + 20;
    private CRAMVersion cramVersion;
    private final byte[] id;

    public CramHeader(CRAMVersion cramVersion, String id) {
        this.cramVersion = cramVersion;
        this.id = new byte[20];
        Arrays.fill(this.id, (byte)0);
        if (id != null) {
            System.arraycopy(id.getBytes(), 0, this.id, 0, Math.min(id.length(), this.id.length));
        }
    }

    public byte[] getId() {
        return this.id;
    }

    public CRAMVersion getCRAMVersion() {
        return this.cramVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CramHeader that = (CramHeader)o;
        return Objects.equals(this.cramVersion, that.cramVersion) && Arrays.equals(this.id, that.id);
    }

    public int hashCode() {
        int result = this.cramVersion.hashCode();
        result = 31 * result + Arrays.hashCode(this.id);
        return result;
    }
}

