/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.TreeSet;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AddForeignKeyDialog;

public class AddForeignKeyCommand
extends AbstractRefactoringCommand {
    private static final ILogger s_log = LoggerController.createLogger(AddForeignKeyCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AddForeignKeyCommand.class);
    protected AddForeignKeyDialog customDialog;

    public AddForeignKeyCommand(ISession session, IDatabaseObjectInfo[] info) {
        super(session, info);
    }

    @Override
    protected void onExecute() throws SQLException {
        if (!(this._info[0] instanceof ITableInfo)) {
            return;
        }
        this.showCustomDialog();
    }

    @Override
    protected String[] generateSQLStatements() throws Exception {
        DatabaseObjectQualifier qualifier = new DatabaseObjectQualifier(this._info[0].getCatalogName(), this._info[0].getSchemaName());
        String[] result = this._dialect.getAddForeignKeyConstraintSQL(this._info[0].getSimpleName(), this.customDialog.getReferencedTable(), this.customDialog.getConstraintName(), Boolean.valueOf(this.customDialog.isDeferrable()), Boolean.valueOf(this.customDialog.isDeferred()), Boolean.valueOf(this.customDialog.isMatchFull()), this.customDialog.isAutoFKIndex(), this.customDialog.getFKIndexName(), this.customDialog.getReferencedColumns(), this.customDialog.getOnUpdateAction(), this.customDialog.getOnDeleteAction(), qualifier, this._sqlPrefs);
        return result;
    }

    @Override
    protected void executeScript(String script) {
        AbstractRefactoringCommand.CommandExecHandler handler = new AbstractRefactoringCommand.CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AddForeignKeyCommand.this.customDialog.setVisible(false);
                        AddForeignKeyCommand.this.customDialog.dispose();
                        AddForeignKeyCommand.this._session.getSchemaInfo().reloadAll();
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialectExt) {
        return dialectExt.supportsAddForeignKeyConstraint();
    }

    private void showCustomDialog() throws SQLException {
        final ITableInfo selectedTable = (ITableInfo)this._info[0];
        String schema = selectedTable.getSchemaName();
        String catalog = selectedTable.getCatalogName();
        ITableInfo[] tables = this._session.getSchemaInfo().getITableInfos(catalog, schema);
        TableColumnInfo[] tableColumnInfos = this._session.getMetaData().getColumnInfo(selectedTable);
        if (tableColumnInfos == null || tableColumnInfos.length == 0) {
            this._session.showErrorMessage(s_stringMgr.getString("AddForeignKeyCommand.noColumns", new Object[]{selectedTable.getSimpleName()}));
            return;
        }
        final TreeSet<String> localColumns = new TreeSet<String>();
        for (TableColumnInfo columns : tableColumnInfos) {
            localColumns.add(columns.getColumnName());
        }
        final HashMap<String, TableColumnInfo[]> allTables = new HashMap<String, TableColumnInfo[]>();
        for (ITableInfo table : tables) {
            TableColumnInfo[] columnInfos;
            if (table.getDatabaseObjectType() != DatabaseObjectType.TABLE || (columnInfos = this._session.getMetaData().getColumnInfo(table)) == null || columnInfos.length <= 0) continue;
            allTables.put(table.getSimpleName(), this._session.getMetaData().getColumnInfo(table));
        }
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AddForeignKeyCommand.this.customDialog = new AddForeignKeyDialog(selectedTable.getSimpleName(), localColumns.toArray(new String[0]), allTables);
                        AddForeignKeyCommand.this.customDialog.addExecuteListener(new AbstractRefactoringCommand.ExecuteListener());
                        AddForeignKeyCommand.this.customDialog.addEditSQLListener(new AbstractRefactoringCommand.EditSQLListener(AddForeignKeyCommand.this.customDialog));
                        AddForeignKeyCommand.this.customDialog.addShowSQLListener(new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, AddForeignKeyCommand.this.customDialog));
                        AddForeignKeyCommand.this.customDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)AddForeignKeyCommand.this._session));
                        AddForeignKeyCommand.this.customDialog.setVisible(true);
                    }
                });
            }
        });
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = AddForeignKeyCommand.access$000().getString("AddForeignKeyCommand.sqlDialogTitle");
    }
}

