/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.link;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;
import net.sourceforge.squirrel_sql.plugins.graph.link.NameLoadFinishListener;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.GraphXmlSerializer;

public class GraphFileDisplayBean {
    public static final String NOT_LOADED_DUMMY_NAME = "...";
    private StringBuffer _name = new StringBuffer("...");
    private File _graphFile;
    private GraphXmlSerializer _serializer;
    private volatile boolean _nameLoadInitialized;
    private NameLoadFinishListener _nameLoadFinishListener;
    private ExecutorService _executorService;

    public GraphFileDisplayBean(File graphFile, GraphXmlSerializer serializer, NameLoadFinishListener nameLoadFinishListener, ExecutorService executorService) {
        this._serializer = serializer;
        this._graphFile = graphFile;
        this._nameLoadFinishListener = nameLoadFinishListener;
        this._executorService = executorService;
    }

    public StringBuffer getName() {
        if (!this._nameLoadInitialized) {
            this._nameLoadInitialized = true;
            SwingWorker<String, Object> sw = new SwingWorker<String, Object>(){

                @Override
                protected String doInBackground() throws Exception {
                    GraphFileDisplayBean.this._name.setLength(0);
                    GraphFileDisplayBean.this._name.append(GraphFileDisplayBean.this._serializer.read().getTitle());
                    return null;
                }

                @Override
                protected void done() {
                    GraphFileDisplayBean.this._nameLoadFinishListener.finishedNameLoad();
                }
            };
            this._executorService.submit(sw);
        }
        return this._name;
    }

    public String getGraphFileName() {
        return this._graphFile.getName();
    }

    public File getGraphFile() {
        return this._graphFile;
    }

    String getLoadedName() {
        try {
            if (NOT_LOADED_DUMMY_NAME.equals(this._name.toString())) {
                this.getName();
                this._executorService.awaitTermination(60L, TimeUnit.SECONDS);
            }
            return this._name.toString();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

