/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tinylaf.borders;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import net.sf.tinylaf.Theme;
import net.sf.tinylaf.TinyLookAndFeel;
import net.sf.tinylaf.TinyPopupFactory;

public class TinyPopupMenuBorder
extends AbstractBorder
implements UIResource {
    public static final int SHADOW_SIZE = 5;
    private static final Insets INSETS_NO_SHADOW = new Insets(2, 2, 2, 2);
    private static final Insets INSETS_SHADOW_LEFT_TO_RIGHT = new Insets(2, 2, 7, 7);
    private static final Insets INSETS_SHADOW_RIGHT_TO_LEFT = new Insets(2, 7, 7, 2);
    public static final Image LEFT_TO_RIGHT_SHADOW_MASK = TinyLookAndFeel.loadIcon("leftToRightShadow.png").getImage();
    public static final Image RIGHT_TO_LEFT_SHADOW_MASK = TinyLookAndFeel.loadIcon("rightToLeftShadow.png").getImage();

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        boolean hasShadow = Boolean.TRUE.equals(((JComponent)c).getClientProperty("SHADOW_POPUP_KEY"));
        boolean isLeftToRight = this.isOrientationLeftToRight(c);
        g.translate(x, y);
        int bx = 0;
        int bw = w;
        int bh = h;
        if (hasShadow) {
            if (isLeftToRight) {
                BufferedImage img = (BufferedImage)((JComponent)c).getClientProperty("VERTICAL_IMAGE_KEY");
                g.drawImage(img, bw -= 5, 0, c);
                img = (BufferedImage)((JComponent)c).getClientProperty("HORIZONTAL_IMAGE_KEY");
                g.drawImage(img, 0, bh -= 5, c);
            } else {
                bh -= 5;
                bx = 5;
                BufferedImage img = (BufferedImage)((JComponent)c).getClientProperty("VERTICAL_IMAGE_KEY");
                if (img != null) {
                    g.drawImage(img, 0, 0, c);
                }
                if ((img = (BufferedImage)((JComponent)c).getClientProperty("HORIZONTAL_IMAGE_KEY")) != null) {
                    g.drawImage(img, 0, bh, c);
                }
            }
        }
        g.setColor(Theme.menuInnerHilightColor.getColor());
        g.drawLine(bx + 1, 1, bw - 3, 1);
        if (isLeftToRight) {
            g.drawLine(bx + 1, 1, bx + 1, bh - 3);
        } else {
            g.drawLine(bw - 2, 1, bw - 2, bh - 2);
        }
        g.setColor(Theme.menuInnerShadowColor.getColor());
        if (isLeftToRight) {
            g.drawLine(bw - 2, 1, bw - 2, bh - 2);
        } else {
            g.drawLine(bx + 1, 1, bx + 1, bh - 2);
        }
        g.drawLine(bx + 1, bh - 2, bw - 2, bh - 2);
        g.setColor(Theme.menuOuterHilightColor.getColor());
        g.drawLine(bx, 0, bw - 2, 0);
        g.drawLine(bx, 0, bx, bh - 1);
        g.setColor(Theme.menuOuterShadowColor.getColor());
        g.drawLine(bw - 1, 0, bw - 1, bh - 1);
        g.drawLine(bx, bh - 1, bw - 1, bh - 1);
        if (hasShadow) {
            if (isLeftToRight) {
                g.drawImage(LEFT_TO_RIGHT_SHADOW_MASK, bw, 4, bw + 5, 8, 6, 0, 11, 4, c);
                g.drawImage(LEFT_TO_RIGHT_SHADOW_MASK, 4, bh, 8, bh + 5, 0, 6, 4, 11, c);
                g.drawImage(LEFT_TO_RIGHT_SHADOW_MASK, bw, bh, bw + 5, bh + 5, 6, 6, 11, 11, c);
                g.drawImage(LEFT_TO_RIGHT_SHADOW_MASK, bw, 8, bw + 5, bh, 6, 4, 11, 5, c);
                g.drawImage(LEFT_TO_RIGHT_SHADOW_MASK, 8, bh, bw, bh + 5, 4, 6, 5, 11, c);
            } else {
                g.drawImage(RIGHT_TO_LEFT_SHADOW_MASK, 0, 4, 5, 8, 0, 0, 5, 4, c);
                g.drawImage(RIGHT_TO_LEFT_SHADOW_MASK, bw - 8, bh, bw - 4, bh + 5, 7, 6, 11, 11, c);
                g.drawImage(RIGHT_TO_LEFT_SHADOW_MASK, 0, bh, 5, bh + 5, 0, 6, 6, 11, c);
                g.drawImage(RIGHT_TO_LEFT_SHADOW_MASK, 0, 8, 5, bh, 0, 4, 5, 5, c);
                g.drawImage(RIGHT_TO_LEFT_SHADOW_MASK, 5, bh, bw - 8, bh + 5, 5, 6, 6, 11, c);
            }
        }
        g.translate(-x, -y);
    }

    public Insets getBorderInsets(Component c) {
        if (TinyPopupFactory.isPopupShadowEnabled()) {
            if (this.isOrientationLeftToRight(c)) {
                return INSETS_SHADOW_LEFT_TO_RIGHT;
            }
            return INSETS_SHADOW_RIGHT_TO_LEFT;
        }
        return INSETS_NO_SHADOW;
    }

    private boolean isOrientationLeftToRight(Component c) {
        Component invoker;
        if (!(c instanceof JComponent)) {
            return true;
        }
        Object co = ((JComponent)c).getClientProperty("COMPONENT_ORIENTATION_KEY");
        if (co == null && c instanceof JPopupMenu && (invoker = ((JPopupMenu)c).getInvoker()) != null) {
            co = invoker.getComponentOrientation();
        }
        return co == null ? true : ((ComponentOrientation)co).isLeftToRight();
    }

    public static String componentOrientationToString(ComponentOrientation co) {
        if (co == null) {
            return "<null>";
        }
        return co.isLeftToRight() ? "left-to-right" : "right-to-left";
    }
}

