/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.codecompletion;

import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.completion.CompletionCandidates;
import net.sourceforge.squirrel_sql.fw.completion.CompletionInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.completionfunctions.CodeCompletionFunction;
import net.sourceforge.squirrel_sql.plugins.codecompletion.completionfunctions.InnerJoin;
import net.sourceforge.squirrel_sql.plugins.codecompletion.completionfunctions.Join;
import net.sourceforge.squirrel_sql.plugins.codecompletion.completionfunctions.LeftJoin;
import net.sourceforge.squirrel_sql.plugins.codecompletion.completionfunctions.RightJoin;

public class CompletionFunctionsModel {
    CodeCompletionFunction[] _completionFunctions;

    CompletionFunctionsModel(ISession session) {
        this._completionFunctions = new CodeCompletionFunction[]{new Join(session), new InnerJoin(session), new LeftJoin(session), new RightJoin(session)};
    }

    public CodeCompletionInfo[] getCompletions() {
        return this._completionFunctions;
    }

    public CompletionCandidates getCompletionCandidates(String textTillCarret) {
        int lastIndexOfLineFeed = textTillCarret.lastIndexOf(10);
        int lastIndexOfHash = textTillCarret.lastIndexOf(35);
        if (lastIndexOfHash <= lastIndexOfLineFeed) {
            return null;
        }
        String functionSting = textTillCarret.substring(lastIndexOfHash);
        for (int i = 0; i < this._completionFunctions.length; ++i) {
            CompletionInfo[] functionResults = this._completionFunctions[i].getFunctionResults(functionSting);
            if (null == functionResults) continue;
            return new CompletionCandidates(functionResults, lastIndexOfHash, functionSting);
        }
        return null;
    }
}

