/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing;

import com.gokgs.client.swing.plaf.ButtonUI;
import com.gokgs.client.swing.plaf.ScrollBarUI;
import com.gokgs.client.swing.plaf.TabbedPaneUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.igoweb.util.swing.GuiUtil;
import org.igoweb.util.swing.Prefs;

public class KgsPlaf
extends MetalLookAndFeel {
    public static final String FONT_SIZE_PREF = "v.93.DUX";
    private static final int bgImgSize = 40;
    private static final Theme theme = new Theme(Prefs.getInt("v.93.DUX", 12));
    private static final HashMap<Object, Object> defaultValues = KgsPlaf.createDefaultValues();

    public KgsPlaf() {
        KgsPlaf.setCurrentTheme(theme);
        UIDefaults defaults = UIManager.getDefaults();
        for (Map.Entry<Object, Object> entry : defaultValues.entrySet()) {
            ((Hashtable)defaults).put(entry.getKey(), entry.getValue());
        }
    }

    private static HashMap<Object, Object> createDefaultValues() {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        ColorUIResource black = new ColorUIResource(Color.black);
        result.put("Label.foreground", black);
        result.put("Button.margin", new InsetsUIResource(2, 10, 2, 10));
        result.put("AFrame.backgroundPaint", KgsPlaf.createBackgroundPaint());
        result.put("AFrame.defaultIcon", GuiUtil.loadImage("org/igoweb/igoweb/client/images/icon.png"));
        result.put("TitledBorder.titleColor", black);
        result.put("org.igoweb.inputBg", theme.getWhite());
        result.put("org.igoweb.outputBg", new ColorUIResource(230, 230, 230));
        result.put("org.igoweb.stdBg", theme.getSecondary3());
        result.put("org.igoweb.selTextBg", theme.getPrimary3());
        result.put("org.igoweb.activeBg", theme.getSecondary2());
        result.put("org.igoweb.highlightBg", new Color(128, 255, 255));
        result.put("OptionPane.errorIcon", KgsPlaf.makeIcon(MetalLookAndFeel.class, "icons/Error.gif"));
        result.put("OptionPane.informationIcon", KgsPlaf.makeIcon(MetalLookAndFeel.class, "icons/Inform.gif"));
        result.put("OptionPane.warningIcon", KgsPlaf.makeIcon(MetalLookAndFeel.class, "icons/Warn.gif"));
        result.put("OptionPane.questionIcon", KgsPlaf.makeIcon(MetalLookAndFeel.class, "icons/Question.gif"));
        result.put("org.igoweb.fontH", new Integer((int)Math.ceil(theme.getControlTextFont().getStringBounds("Xy0", new FontRenderContext(new AffineTransform(), false, false)).getHeight())));
        result.put("ButtonUI", ButtonUI.class.getName());
        result.put("ScrollBarUI", ScrollBarUI.class.getName());
        result.put("TabbedPaneUI", TabbedPaneUI.class.getName());
        return result;
    }

    private static Paint createBackgroundPaint() {
        Random rnd = new Random();
        BufferedImage bgImage = new BufferedImage(40, 40, 1);
        Graphics2D g2d = (Graphics2D)bgImage.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setColor(new Color(46, 139, 87));
        g2d.fillRect(0, 0, 40, 40);
        g2d.setColor(new Color(55, 167, 104));
        g2d.setStroke(new BasicStroke(2.8400002f, 0, 2));
        float lineLen = 37.333332f;
        GeneralPath path = new GeneralPath(1, 40);
        for (int i = 0; i < 5; ++i) {
            float offset = rnd.nextFloat() * 40.0f;
            float primaryX = (float)i * 40.0f / 5.0f - offset;
            float primaryY = offset + 2.6666667f;
            path.moveTo(primaryX, primaryY);
            path.lineTo(primaryX - lineLen, primaryY + lineLen);
            path.moveTo(primaryX + 40.0f, primaryY - 40.0f);
            path.lineTo(primaryX + 40.0f - lineLen, primaryY - 40.0f + lineLen);
            path.moveTo(primaryX += 40.0f, primaryY);
            path.lineTo(primaryX - lineLen, primaryY + lineLen);
            path.moveTo(primaryX + 40.0f, primaryY - 40.0f);
            path.lineTo(primaryX + 40.0f - lineLen, primaryY - 40.0f + lineLen);
        }
        g2d.draw(path);
        return new TexturePaint(bgImage, new Rectangle2D.Float(0.0f, 0.0f, 40.0f, 40.0f));
    }

    private static class Theme
    extends DefaultMetalTheme {
        private FontUIResource stdFont;
        public static final ColorUIResource blueShading = new ColorUIResource(102, 102, 153);
        private final ColorUIResource markFocus = new ColorUIResource(153, 153, 204);
        private static final ColorUIResource prim3 = new ColorUIResource(204, 204, 255);
        private static final ColorUIResource sec1 = new ColorUIResource(102, 102, 102);
        public static final ColorUIResource activeBg = new ColorUIResource(153, 153, 153);
        public static final ColorUIResource stdBg = new ColorUIResource(204, 204, 204);
        public static final ColorUIResource myWhite = new ColorUIResource(Color.white);

        public Theme(int fontSize) {
            this.stdFont = new FontUIResource("SansSerif", 0, fontSize);
        }

        @Override
        public FontUIResource getControlTextFont() {
            return this.stdFont;
        }

        @Override
        public String getName() {
            return "KGS";
        }

        @Override
        protected ColorUIResource getWhite() {
            return myWhite;
        }

        @Override
        protected ColorUIResource getPrimary1() {
            return blueShading;
        }

        @Override
        protected ColorUIResource getPrimary2() {
            return this.markFocus;
        }

        @Override
        protected ColorUIResource getPrimary3() {
            return prim3;
        }

        @Override
        protected ColorUIResource getSecondary1() {
            return sec1;
        }

        @Override
        protected ColorUIResource getSecondary2() {
            return activeBg;
        }

        @Override
        protected ColorUIResource getSecondary3() {
            return stdBg;
        }

        @Override
        public FontUIResource getSystemTextFont() {
            return this.stdFont;
        }

        @Override
        public FontUIResource getUserTextFont() {
            return this.stdFont;
        }

        @Override
        public FontUIResource getMenuTextFont() {
            return this.stdFont;
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.stdFont;
        }

        @Override
        public FontUIResource getSubTextFont() {
            return this.stdFont;
        }
    }
}

