/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.RMIHashes;
import gnu.java.rmi.server.RMIObjectInputStream;
import gnu.java.rmi.server.RMIVoidValue;
import gnu.java.rmi.server.UnicastConnection;
import gnu.java.rmi.server.UnicastConnectionManager;
import gnu.java.rmi.server.UnicastRef;
import gnu.java.rmi.server.UnicastRemoteCall;
import gnu.java.rmi.server.UnicastRemoteStub;
import gnu.java.rmi.server.UnicastServer;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.ServerRef;
import java.rmi.server.Skeleton;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UnicastServerRef
extends UnicastRef
implements ServerRef {
    private static final Class[] stubprototype;
    Remote myself;
    private Skeleton skel;
    private RemoteStub stub;
    private Hashtable methods;
    static /* synthetic */ Class class$java$rmi$server$RemoteRef;
    static /* synthetic */ Class class$java$rmi$server$UnicastRemoteObject;

    public RemoteStub exportObject(Remote obj) throws RemoteException {
        if (this.myself == null) {
            Class expCls;
            this.myself = obj;
            this.manager.serverobj = obj;
            Class cls = obj.getClass();
            try {
                expCls = this.findStubSkelClass(cls);
            }
            catch (Exception ex) {
                throw new RemoteException("can not find stubs for class: " + cls, ex);
            }
            this.stub = (RemoteStub)this.getHelperClass(expCls, "_Stub");
            if (this.stub == null) {
                throw new RemoteException("failed to export: " + cls);
            }
            this.skel = (Skeleton)this.getHelperClass(expCls, "_Skel");
            this.buildMethodHash(obj.getClass(), true);
            UnicastServer.exportObject(this);
        }
        return this.stub;
    }

    public RemoteStub exportObject(Remote remote, Object obj) throws RemoteException {
        return this.exportObject(remote);
    }

    public RemoteStub getStub() {
        return this.stub;
    }

    public boolean unexportObject(Remote obj, boolean force) {
        this.buildMethodHash(obj.getClass(), false);
        return UnicastServer.unexportObject(this, force);
    }

    private final Class findStubSkelClass(Class startCls) throws Exception {
        Class cls = startCls;
        while (true) {
            try {
                String stubClassname = cls.getName() + "_Stub";
                ClassLoader cl = cls.getClassLoader();
                Class scls = cl == null ? Class.forName(stubClassname) : cl.loadClass(stubClassname);
                return cls;
            }
            catch (ClassNotFoundException e) {
                Class superCls;
                block8: {
                    block7: {
                        superCls = cls.getSuperclass();
                        if (superCls == null) break block7;
                        Class clazz = class$java$rmi$server$UnicastRemoteObject;
                        if (clazz == null) {
                            clazz = UnicastServerRef.class("[Ljava.rmi.server.UnicastRemoteObject;", false);
                        }
                        if (superCls != clazz) break block8;
                    }
                    throw new Exception("Neither " + startCls + " nor one of their superclasses (like" + cls + ") has a _Stub");
                }
                cls = superCls;
                continue;
            }
            break;
        }
    }

    private final Object getHelperClass(Class cls, String type) {
        try {
            Class scls;
            String classname = cls.getName();
            ClassLoader cl = cls.getClassLoader();
            Class clazz = scls = cl == null ? Class.forName(classname + type) : cl.loadClass(classname + type);
            if (type.equals("_Stub")) {
                try {
                    Constructor con = scls.getConstructor(stubprototype);
                    return con.newInstance(new Object[]{this});
                }
                catch (NoSuchMethodException e) {
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (InvocationTargetException stub) {
                    // empty catch block
                }
                RemoteStub stub = (RemoteStub)scls.newInstance();
                UnicastRemoteStub.setStubRef(stub, this);
                return stub;
            }
            return scls.newInstance();
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public String getClientHost() throws ServerNotActiveException {
        return RemoteServer.getClientHost();
    }

    private final void buildMethodHash(Class cls, boolean build) {
        Method[] meths = cls.getMethods();
        int i = 0;
        while (i < meths.length) {
            if (!meths[i].getDeclaringClass().getName().startsWith("java.")) {
                long hash = RMIHashes.getMethodHash(meths[i]);
                if (build) {
                    this.methods.put(new Long(hash), meths[i]);
                } else {
                    this.methods.remove(new Long(hash));
                }
            }
            ++i;
        }
    }

    Class getMethodReturnType(int method, long hash) throws Exception {
        if (method == -1) {
            Method meth = (Method)this.methods.get(new Long(hash));
            return meth.getReturnType();
        }
        return null;
    }

    public Object incomingMessageCall(UnicastConnection conn, int method, long hash) throws Exception {
        if (method == -1) {
            Method meth = (Method)this.methods.get(new Long(hash));
            if (meth == null) {
                throw new NoSuchMethodException();
            }
            ObjectInputStream in = conn.getObjectInputStream();
            int nrargs = meth.getParameterTypes().length;
            Object[] args = new Object[nrargs];
            int i = 0;
            while (i < nrargs) {
                try {
                    args[i] = ((RMIObjectInputStream)in).readValue(meth.getParameterTypes()[i]);
                }
                catch (Exception t) {
                    t.printStackTrace();
                    throw t;
                }
                ++i;
            }
            Object ret = null;
            try {
                ret = meth.invoke(this.myself, args);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new Error("The remote method threw a java.lang.Throwable that is neither java.lang.Exception nor java.lang.Error.", e);
            }
            return ret;
        }
        if (this.skel == null) {
            throw new NoSuchMethodException();
        }
        UnicastRemoteCall call = new UnicastRemoteCall(conn);
        this.skel.dispatch(this.myself, call, method, hash);
        if (!call.isReturnValue()) {
            return RMIVoidValue.INSTANCE;
        }
        return call.returnValue();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.methods = new Hashtable();
    }

    UnicastServerRef() {
        this.this();
    }

    public UnicastServerRef(ObjID id, int port, RMIServerSocketFactory ssf) throws RemoteException {
        super(id);
        this.this();
        this.manager = UnicastConnectionManager.getInstance(port, ssf);
    }

    static {
        Class[] classArray = new Class[1];
        Class clazz = class$java$rmi$server$RemoteRef;
        if (clazz == null) {
            clazz = class$java$rmi$server$RemoteRef = UnicastServerRef.class("[Ljava.rmi.server.RemoteRef;", false);
        }
        classArray[0] = clazz;
        stubprototype = classArray;
    }
}

