/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.ConnectionPoints;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintData;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintGraph;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintHit;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintIconHandler;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintIconHandlerListener;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintViewListener;
import net.sourceforge.squirrel_sql.plugins.graph.FoldingPoint;
import net.sourceforge.squirrel_sql.plugins.graph.GraphComponent;
import net.sourceforge.squirrel_sql.plugins.graph.GraphDesktopController;
import net.sourceforge.squirrel_sql.plugins.graph.GraphLine;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrame;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrameController;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.ConfigureNonDbConstraintController;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.ConstraintViewXmlBean;

public class ConstraintView
implements GraphComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ConstraintView.class);
    private GraphDesktopController _desktopController;
    private boolean _isSelected;
    private JPopupMenu _connectLinePopup;
    private JPopupMenu _foldingPointPopUp;
    private JMenuItem _mnuAddFoldingPoint;
    private JMenuItem _mnuShowDDL;
    private JMenuItem _mnuScriptDDL;
    private JCheckBoxMenuItem _mnuShowThisConstraintName;
    private JMenuItem _mnuRemoveNonDbConstraint;
    private JMenuItem _mnuConfigureNonDbConstraint;
    private JMenuItem _mnuRemoveFoldingPoint;
    private Point _lastPopupClickPoint;
    private ConstraintGraph _constraintGraph = new ConstraintGraph();
    private ConstraintData _constraintData;
    public static final int STUB_LENGTH = 20;
    private ISession _session;
    private TableFrameController _fkFrameOriginatingFrom;
    private TableFrameController _pkFramePointingTo;
    private Vector<ConstraintViewListener> _constraintViewListeners = new Vector();
    private ConstraintIconHandler _constraintIconHandler;
    private boolean _hide;

    public ConstraintView(ConstraintData constraintData, GraphDesktopController desktopController, ISession session, ConstraintIconHandlerListener constraintIconHandlerListener) {
        this._constraintIconHandler = new ConstraintIconHandler(constraintIconHandlerListener);
        this._constraintData = constraintData;
        this._desktopController = desktopController;
        this._session = session;
        this.createPopup();
    }

    public ConstraintView(ConstraintViewXmlBean constraintViewXmlBean, GraphDesktopController desktopController, ISession session, ConstraintIconHandlerListener constraintIconHandlerListener) {
        this._constraintIconHandler = new ConstraintIconHandler(constraintIconHandlerListener);
        this._desktopController = desktopController;
        this._session = session;
        this._constraintData = new ConstraintData(constraintViewXmlBean.getConstraintDataXmlBean());
        this._constraintGraph = new ConstraintGraph(constraintViewXmlBean.getConstraintGraphXmlBean(), this._desktopController.getZoomer());
        this.createPopup();
    }

    public ConstraintViewXmlBean getXmlBean() {
        ConstraintViewXmlBean ret = new ConstraintViewXmlBean();
        ret.setConstraintDataXmlBean(this._constraintData.getXmlBean());
        ret.setConstraintGraphXmlBean(this._constraintGraph.getXmlBean());
        return ret;
    }

    private void createPopup() {
        this._connectLinePopup = new JPopupMenu();
        this._mnuAddFoldingPoint = new JMenuItem(s_stringMgr.getString("graph.addFoldingPoint"));
        this._mnuAddFoldingPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintView.this.onAddFoldingPoint();
            }
        });
        this._connectLinePopup.add(this._mnuAddFoldingPoint);
        this._mnuShowDDL = new JMenuItem(s_stringMgr.getString("graph.showddl"));
        this._mnuShowDDL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintView.this.onShowDDL();
            }
        });
        this._connectLinePopup.add(this._mnuShowDDL);
        this._mnuScriptDDL = new JMenuItem(s_stringMgr.getString("graph.scriptdd"));
        this._mnuScriptDDL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintView.this.onScriptDDL();
            }
        });
        this._connectLinePopup.add(this._mnuScriptDDL);
        this._mnuShowThisConstraintName = new JCheckBoxMenuItem(s_stringMgr.getString("graph.showThisConstraintName"));
        this._mnuShowThisConstraintName.setSelected(this._constraintData.isShowThisConstraintName());
        this._mnuShowThisConstraintName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintView.this.onShowThisConstraintName();
            }
        });
        this._connectLinePopup.add(this._mnuShowThisConstraintName);
        if (this._constraintData.isNonDbConstraint()) {
            this._mnuRemoveNonDbConstraint = new JMenuItem(s_stringMgr.getString("graph.removeNonDbConstraint"));
            this._mnuRemoveNonDbConstraint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConstraintView.this.onRemoveNonDbConstraint();
                }
            });
            this._connectLinePopup.add(this._mnuRemoveNonDbConstraint);
            this._mnuConfigureNonDbConstraint = new JMenuItem(s_stringMgr.getString("graph.configureNonDbConstraint"));
            this._mnuConfigureNonDbConstraint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConstraintView.this.onConfigureNonDbConstraint();
                }
            });
            this._connectLinePopup.add(this._mnuConfigureNonDbConstraint);
        }
        this._foldingPointPopUp = new JPopupMenu();
        this._mnuRemoveFoldingPoint = new JMenuItem(s_stringMgr.getString("graph.removeFoldingPoint"));
        this._mnuRemoveFoldingPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintView.this.onRemoveFoldingPoint();
            }
        });
        this._foldingPointPopUp.add(this._mnuRemoveFoldingPoint);
    }

    private void onShowThisConstraintName() {
        this._constraintData.setShowThisConstraintName(this._mnuShowThisConstraintName.isSelected());
        this._desktopController.repaint();
    }

    private void onConfigureNonDbConstraint() {
        new ConfigureNonDbConstraintController(this, this._fkFrameOriginatingFrom, this._pkFramePointingTo);
        this.generateFoldingPointIfLinesWouldCoverEachOther();
        this._fkFrameOriginatingFrom.recalculateConnections();
    }

    public boolean generateFoldingPointIfLinesWouldCoverEachOther() {
        ArrayList<ConstraintView> matches = this._fkFrameOriginatingFrom.getConstraintViewsModel().checkForMatches(this);
        if (0 < matches.size() && null == this.getFirstFoldingPoint()) {
            boolean allMachesHaveFoldingPoints = true;
            for (ConstraintView match : matches) {
                if (null != match.getFirstFoldingPoint()) continue;
                allMachesHaveFoldingPoints = false;
                break;
            }
            if (!allMachesHaveFoldingPoints) {
                Point p = new Point(this._constraintGraph.getMainLine().getBegin());
                p.x += (this._constraintGraph.getMainLine().getEnd().x - this._constraintGraph.getMainLine().getBegin().x) / 2 + 30 * matches.size();
                p.y += (this._constraintGraph.getMainLine().getEnd().y - this._constraintGraph.getMainLine().getBegin().y) / 2 + 30 * matches.size();
                this._constraintGraph.setHitConnectLine(this._constraintGraph.getMainLine());
                this.addFoldingPointAt(p);
                return true;
            }
        }
        return false;
    }

    private void onRemoveNonDbConstraint() {
        ConstraintViewListener[] clone;
        for (ConstraintViewListener listener : clone = this._constraintViewListeners.toArray(new ConstraintViewListener[0])) {
            listener.removeNonDbConstraint(this);
        }
    }

    private void onRemoveFoldingPoint() {
        this._constraintGraph.removeHitFoldingPoint();
        this._desktopController.repaint();
    }

    private void onScriptDDL() {
        String[] lines = this._constraintData.getDDL();
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (int i = 0; i < lines.length; ++i) {
            sb.append(lines[i]).append('\n');
        }
        this._session.getSessionSheet().getSQLEntryPanel().appendText(sb.toString());
    }

    private void onShowDDL() {
        final String[] lines = this._constraintData.getDDL();
        final JInternalFrame ddlFrame = new JInternalFrame(this._constraintData.getTitle(), true, true);
        StringBuffer sb = new StringBuffer();
        sb.append(lines[0]);
        for (int i = 1; i < lines.length; ++i) {
            sb.append('\n').append(lines[i]);
        }
        final JTextPane txtDDL = new JTextPane();
        txtDDL.setText(sb.toString());
        txtDDL.setEditable(false);
        ddlFrame.getContentPane().add(new JScrollPane(txtDDL));
        this._desktopController.addFrame(ddlFrame);
        ddlFrame.setBounds(this._lastPopupClickPoint.x, this._lastPopupClickPoint.y, 20, 20);
        ddlFrame.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConstraintView.this.recalculateDDLFrameSize(ddlFrame, txtDDL, lines);
            }
        });
    }

    private void recalculateDDLFrameSize(JInternalFrame ddlFrame, JTextPane txtDDL, String[] lines) {
        FontMetrics fm = txtDDL.getFontMetrics(txtDDL.getFont());
        int txtHeight = fm.getHeight() * lines.length;
        int txtWidht = 0;
        for (int i = 0; i < lines.length; ++i) {
            txtWidht = Math.max(txtWidht, fm.stringWidth(lines[i]));
        }
        BasicInternalFrameUI ui = (BasicInternalFrameUI)ddlFrame.getUI();
        int titleHeight = ui.getNorthPane().getHeight();
        ddlFrame.setSize(txtWidht + 20, txtHeight + titleHeight + 20);
    }

    private void onAddFoldingPoint() {
        this.addFoldingPointAt(this._lastPopupClickPoint);
    }

    private void addFoldingPointAt(Point lastPopupClickPoint) {
        double zoom = this._desktopController.getZoomer().getZoom();
        Point backTransformedPoint = new Point((int)((double)lastPopupClickPoint.x / zoom + 0.5), (int)((double)lastPopupClickPoint.y / zoom + 0.5));
        this._constraintGraph.addFoldingPointToHitConnectLine(new FoldingPoint(backTransformedPoint, this._desktopController.getZoomer()));
        this._desktopController.repaint();
    }

    public void setConnectionPoints(ConnectionPoints fkPoints, ConnectionPoints pkPoints, TableFrameController fkFrameOriginatingFrom, TableFrameController pkFramePointingTo, ConstraintViewListener constraintViewListener) {
        double zoom = 1.0;
        if (null != this._desktopController.getZoomer()) {
            zoom = this._desktopController.getZoomer().getZoom();
        }
        this._fkFrameOriginatingFrom = fkFrameOriginatingFrom;
        this._pkFramePointingTo = pkFramePointingTo;
        this.addConstraintViewListener(constraintViewListener);
        int fkCenterY = this.getCenterY(fkPoints.points);
        int pkCenterY = this.getCenterY(pkPoints.points);
        int signFkStub = fkPoints.pointsAreLeftOfWindow ? -1 : 1;
        int signPkStub = pkPoints.pointsAreLeftOfWindow ? -1 : 1;
        Point fkGatherPoint = new Point((int)((double)fkPoints.points[0].x + (double)(signFkStub * 20) * zoom + 0.5), fkCenterY);
        Point pkGatherPoint = new Point((int)((double)pkPoints.points[0].x + (double)(signPkStub * 20) * zoom + 0.5), pkCenterY);
        GraphLine[] fkStubLines = new GraphLine[fkPoints.points.length];
        for (int i = 0; i < fkPoints.points.length; ++i) {
            fkStubLines[i] = new GraphLine(fkPoints.points[i], fkGatherPoint);
        }
        this._constraintGraph.setFkStubLines(fkStubLines);
        GraphLine[] pkStubLines = new GraphLine[pkPoints.points.length];
        for (int i = 0; i < pkPoints.points.length; ++i) {
            pkStubLines[i] = new GraphLine(pkPoints.points[i], pkGatherPoint);
        }
        this._constraintGraph.setPkStubLines(pkStubLines);
        this._constraintGraph.setFkGatherPoint(fkGatherPoint);
        this._constraintGraph.setPkGatherPoint(pkGatherPoint);
    }

    @Override
    public void paint(Graphics g, boolean isPrinting) {
        if (!this.isVisible()) {
            return;
        }
        Color colBuf = g.getColor();
        if (this._constraintData.isNonDbConstraint()) {
            g.setColor(Color.blue);
        } else {
            g.setColor(Color.black);
        }
        GraphLine[] lines = this._constraintGraph.getAllLines();
        for (int i = 0; i < lines.length; ++i) {
            this.drawLine(g, lines[i]);
        }
        GraphLine[] linesToArrow = this._constraintGraph.getLinesToArrow();
        for (int i = 0; i < linesToArrow.length; ++i) {
            this.paintArrow(g, linesToArrow[i].getEnd().x, linesToArrow[i].getEnd().y, linesToArrow[i].getBegin().x, linesToArrow[i].getBegin().y);
        }
        GraphLine mainLine = this._constraintGraph.getMainLine();
        if (this._desktopController.isShowConstraintNames() || this._constraintData.isShowThisConstraintName()) {
            this.drawConstraintNameOnLine(g, mainLine);
        }
        this._constraintIconHandler.paintJoinIcon(g, mainLine, this._fkFrameOriginatingFrom, this._pkFramePointingTo, this._desktopController, this._constraintData);
        Vector<FoldingPoint> foldingPoints = this._constraintGraph.getFoldingPoints();
        if (!isPrinting) {
            for (int i = 0; i < foldingPoints.size(); ++i) {
                this.drawFoldingPoint(g, foldingPoints.get(i));
            }
        }
        g.setColor(colBuf);
    }

    private boolean isVisible() {
        return !this._desktopController.getModeManager().getMode().isQueryBuilder() || !this._hide || !this.getData().getConstraintQueryData().isNoJoin();
    }

    private void drawConstraintNameOnLine(Graphics g, GraphLine line) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform origTrans = g2d.getTransform();
        try {
            Point left;
            Point right;
            double zoom = this._desktopController.getZoomer().getZoom();
            StringBuffer drawText = new StringBuffer(this._constraintData.getConstraintName());
            int lineLen = this.getLineLen(line);
            FontMetrics fontMetrics = g2d.getFontMetrics(g2d.getFont());
            while ((double)lineLen < (double)fontMetrics.stringWidth(drawText.toString()) * zoom + 0.5 && 0 != drawText.length()) {
                drawText.setLength(drawText.length() - 1);
            }
            if (line.getBegin().x > line.getEnd().x) {
                right = line.getBegin();
                left = line.getEnd();
            } else if (line.getBegin().x < line.getEnd().x) {
                right = line.getEnd();
                left = line.getBegin();
            } else if (line.getBegin().y < line.getEnd().y) {
                right = line.getEnd();
                left = line.getBegin();
            } else {
                right = line.getBegin();
                left = line.getEnd();
            }
            double angle = 0 != right.x - left.x ? Math.atan((double)(right.y - left.y) / (double)(right.x - left.x)) : 1.5707963267948966;
            AffineTransform at = new AffineTransform();
            at.setToRotation(angle);
            at.scale(zoom, zoom);
            g2d.transform(at);
            Point invTransBeg = (Point)at.inverseTransform(left, new Point());
            g2d.drawString(drawText.toString(), invTransBeg.x, invTransBeg.y);
            g2d.setTransform(origTrans);
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
        finally {
            g2d.setTransform(origTrans);
        }
    }

    private int getLineLen(GraphLine line) {
        return (int)Math.sqrt((line.getBegin().x - line.getEnd().x) * (line.getBegin().x - line.getEnd().x) + (line.getBegin().y - line.getEnd().y) * (line.getBegin().y - line.getEnd().y));
    }

    @Override
    public Dimension getRequiredSize() {
        Dimension ret = new Dimension();
        for (int i = 0; i < this._constraintGraph.getFoldingPoints().size(); ++i) {
            FoldingPoint fp = this._constraintGraph.getFoldingPoints().get(i);
            if (fp.getZoomedPoint().x > ret.width) {
                ret.width = fp.getZoomedPoint().x;
            }
            if (fp.getZoomedPoint().y <= ret.height) continue;
            ret.height = fp.getZoomedPoint().y;
        }
        ret.width += 5;
        ret.height += 5;
        return ret;
    }

    private void paintArrow(Graphics g, int x1, int y1, int x2, int y2) {
        double zoom = this._desktopController.getZoomer().getZoom();
        double sAng = 0.5;
        Point c = new Point(x2, y2);
        Point a = new Point((int)((double)x1 + sAng * (double)(y2 - y1)), (int)((double)y1 - sAng * (double)(x2 - x1)));
        Point b = new Point((int)((double)x1 - sAng * (double)(y2 - y1)), (int)((double)y1 + sAng * (double)(x2 - x1)));
        double sLen = 10.0 / Math.sqrt((a.x - c.x) * (a.x - c.x) + (a.y - c.y) * (a.y - c.y)) * zoom;
        Point arrPa = new Point((int)((double)c.x + sLen * (double)(a.x - c.x)), (int)((double)c.y + sLen * (double)(a.y - c.y)));
        Point arrPb = new Point((int)((double)c.x + sLen * (double)(b.x - c.x)), (int)((double)c.y + sLen * (double)(b.y - c.y)));
        Polygon pg = new Polygon();
        pg.addPoint(arrPa.x, arrPa.y);
        pg.addPoint(arrPb.x, arrPb.y);
        pg.addPoint(c.x, c.y);
        g.fillPolygon(pg);
    }

    private void drawFoldingPoint(Graphics g, FoldingPoint fp) {
        int rad = 4;
        if (this._isSelected) {
            rad = 5;
        }
        g.fillOval((int)((double)fp.getZoomedPoint().x + 0.5) - rad, (int)((double)fp.getZoomedPoint().y + 0.5) - rad, 2 * rad, 2 * rad);
    }

    private void drawLine(Graphics g, GraphLine line) {
        if (this._isSelected) {
            g.fillPolygon(this.createPolygon(line.getBegin().x, line.getBegin().y, line.getEnd().x, line.getEnd().y, 1));
        } else {
            g.drawLine(line.getBegin().x, line.getBegin().y, line.getEnd().x, line.getEnd().y);
        }
    }

    public Polygon createPolygon(int x1, int y1, int x2, int y2, int halfThickness) {
        Polygon ret = new Polygon();
        if (x1 < x2 && y1 < y2) {
            ret.addPoint(x1 + halfThickness, y1 - halfThickness);
            ret.addPoint(x1 - halfThickness, y1 + halfThickness);
            ret.addPoint(x2 - halfThickness, y2 + halfThickness);
            ret.addPoint(x2 + halfThickness, y2 - halfThickness);
        } else if (x1 > x2 && y1 > y2) {
            ret.addPoint(x1 - halfThickness, y1 + halfThickness);
            ret.addPoint(x1 + halfThickness, y1 - halfThickness);
            ret.addPoint(x2 + halfThickness, y2 - halfThickness);
            ret.addPoint(x2 - halfThickness, y2 + halfThickness);
        } else {
            ret.addPoint(x1 + halfThickness, y1 + halfThickness);
            ret.addPoint(x1 - halfThickness, y1 - halfThickness);
            ret.addPoint(x2 - halfThickness, y2 - halfThickness);
            ret.addPoint(x2 + halfThickness, y2 + halfThickness);
        }
        return ret;
    }

    private int getCenterY(Point[] points) {
        int ret = 0;
        for (int i = 0; i < points.length; ++i) {
            ret += points[i].y;
        }
        return ret / points.length;
    }

    public ConstraintHit hitMe(MouseEvent e) {
        if (!this.isVisible()) {
            return ConstraintHit.NONE;
        }
        GraphLine mainLine = this._constraintGraph.getMainLine();
        if (this._constraintIconHandler.hitMe(e, mainLine, this._fkFrameOriginatingFrom, this._pkFramePointingTo, this._desktopController, this._constraintData)) {
            return ConstraintHit.JOIN_ICON;
        }
        Vector<FoldingPoint> foldingPoints = this._constraintGraph.getFoldingPoints();
        int hitDist = 8;
        for (int i = 0; i < foldingPoints.size(); ++i) {
            FoldingPoint foldingPoint = foldingPoints.get(i);
            if (Math.abs(e.getPoint().x - foldingPoint.getZoomedPoint().x) >= hitDist || Math.abs(e.getPoint().y - foldingPoint.getZoomedPoint().y) >= hitDist) continue;
            this._constraintGraph.setHitFoldingPoint(foldingPoint);
            return ConstraintHit.LINE;
        }
        GraphLine[] lines = this._constraintGraph.getConnectLines();
        for (int i = 0; i < lines.length; ++i) {
            Polygon pg = this.createPolygon(lines[i].getBegin().x, lines[i].getBegin().y, lines[i].getEnd().x, lines[i].getEnd().y, 3);
            if (!pg.contains(e.getPoint())) continue;
            this._constraintGraph.setHitConnectLine(lines[i]);
            return ConstraintHit.LINE;
        }
        return ConstraintHit.NONE;
    }

    public void setSelected(boolean b) {
        this._isSelected = b;
        this._desktopController.repaint();
    }

    public boolean isSelected() {
        return this._isSelected;
    }

    public void removeAllFoldingPoints() {
        this._constraintGraph.removeAllFoldingPoints();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConstraintView) {
            return ((ConstraintView)obj)._constraintData.equals(this._constraintData);
        }
        return false;
    }

    public int hashCode() {
        return this._constraintData.hashCode();
    }

    public ConstraintData getData() {
        return this._constraintData;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this._lastPopupClickPoint = new Point(e.getX(), e.getY());
            if (this._constraintGraph.isHitOnConnectLine()) {
                this._connectLinePopup.show(e.getComponent(), e.getX(), e.getY());
            } else {
                this._foldingPointPopUp.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public boolean mouseDragged(MouseEvent e) {
        boolean foldingPointMoved = false;
        if (!this._constraintGraph.isHitOnConnectLine()) {
            double zoom = this._desktopController.getZoomer().getZoom();
            Point backTransformedPoint = e.getPoint();
            backTransformedPoint.x = (int)((double)backTransformedPoint.x / zoom + 0.5);
            backTransformedPoint.y = (int)((double)backTransformedPoint.y / zoom + 0.5);
            this._constraintGraph.moveLastHitFoldingPointTo(new FoldingPoint(backTransformedPoint, this._desktopController.getZoomer()));
            foldingPointMoved = true;
            ConstraintViewListener[] listeners = this._constraintViewListeners.toArray(new ConstraintViewListener[this._constraintViewListeners.size()]);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].foldingPointMoved(this);
            }
        }
        return foldingPointMoved;
    }

    public FoldingPoint getFirstFoldingPoint() {
        return this._constraintGraph.getFirstFoldingPoint();
    }

    public FoldingPoint getLastFoldingPoint() {
        return this._constraintGraph.getLastFoldingPoint();
    }

    public TableFrameController getPkFramePointingTo() {
        return this._pkFramePointingTo;
    }

    public void addConstraintViewListener(ConstraintViewListener constraintViewListener) {
        this._constraintViewListeners.remove(constraintViewListener);
        this._constraintViewListeners.add(constraintViewListener);
    }

    public void setData(ConstraintData constraintData) {
        constraintData.setConstraintQueryData(this._constraintData.getConstraintQueryData());
        this._constraintData = constraintData;
    }

    public Vector<FoldingPoint> getFoldingPoints() {
        return this._constraintGraph.getFoldingPoints();
    }

    public boolean isAttachedTo(TableFrame tableFrame) {
        return tableFrame == this._pkFramePointingTo.getFrame() || tableFrame == this._fkFrameOriginatingFrom.getFrame();
    }

    public void setHideIfNoJoin(boolean hideIfNoJoin) {
        this._hide = this.getData().getConstraintQueryData().isNoJoin() && hideIfNoJoin;
    }

    public boolean isUniddenNoJoin() {
        return this.isVisible() && this.getData().getConstraintQueryData().isNoJoin();
    }

    public boolean matches(ConstraintView view) {
        return this._constraintData.matches(view.getData());
    }

    public boolean hasOverlap(ConstraintView mergeTarget) {
        return this._constraintData.hasOverlap(mergeTarget.getData());
    }
}

