/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import net.sourceforge.squirrel_sql.client.gui.HtmlViewerPanelListenerEvent;
import net.sourceforge.squirrel_sql.client.gui.IHtmlViewerPanelListener;
import net.sourceforge.squirrel_sql.fw.gui.CursorChanger;
import net.sourceforge.squirrel_sql.fw.gui.TextPopupMenu;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class HtmlViewerPanel
extends JPanel {
    private static final ILogger s_log = LoggerController.createLogger(HtmlViewerPanel.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(HtmlViewerPanel.class);
    private final JEditorPane _contentsTxt = new JEditorPane();
    private JScrollPane _contentsScrollPane;
    private URL _homeURL;
    private URL _currentURL;
    private final List<URL> _history = new LinkedList<URL>();
    private int _historyIndex = -1;
    private EventListenerList _listenerList = new EventListenerList();

    public HtmlViewerPanel(URL url) {
        this.createGUI();
        this.setHomeURL(url);
        this.setURL(url);
    }

    public URL getURL() {
        return this._currentURL;
    }

    public URL getHomeURL() {
        return this._homeURL;
    }

    public void setHomeURL(URL homeURL) {
        this._homeURL = homeURL;
        this.fireHomeURLChanged();
    }

    public void addListener(IHtmlViewerPanelListener lis) {
        this._listenerList.add(IHtmlViewerPanelListener.class, lis);
    }

    void removeListener(IHtmlViewerPanelListener lis) {
        this._listenerList.remove(IHtmlViewerPanelListener.class, lis);
    }

    public synchronized void gotoURL(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL == null");
        }
        if (!url.equals(this._currentURL)) {
            ListIterator<URL> it = this._history.listIterator(this._historyIndex + 1);
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            this._history.add(url);
            this._historyIndex = this._history.size() - 1;
            this._contentsTxt.setPage(url);
            this._currentURL = url;
            this.fireURLChanged();
        }
    }

    public synchronized void goBack() {
        if (this._historyIndex > 0 && this._historyIndex < this._history.size()) {
            this.displayURL(this._history.get(--this._historyIndex));
        }
    }

    public synchronized void goForward() {
        if (this._historyIndex > -1 && this._historyIndex < this._history.size() - 1) {
            this.displayURL(this._history.get(++this._historyIndex));
        }
    }

    public synchronized void goHome() {
        this._historyIndex = 0;
        this.displayURL(this._homeURL);
    }

    public void refreshPage() {
        Point pos = this._contentsScrollPane.getViewport().getViewPosition();
        this.displayURL(this._currentURL);
        this._contentsScrollPane.getViewport().setViewPosition(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setURL(URL url) {
        if (url != null) {
            CursorChanger cursorChg = new CursorChanger(this);
            cursorChg.show();
            try {
                this.displayURL(url);
                this._history.add(url);
                this._historyIndex = 0;
            }
            finally {
                cursorChg.restore();
            }
        }
    }

    private void displayURL(URL url) {
        if (url != null) {
            try {
                this._contentsTxt.setPage(url);
                this._currentURL = url;
                this.fireURLChanged();
            }
            catch (Exception ex) {
                s_log.error(s_stringMgr.getString("HtmlViewerPanel.error.displayurl"), ex);
            }
        }
    }

    private void fireURLChanged() {
        Object[] listeners = this._listenerList.getListenerList();
        HtmlViewerPanelListenerEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IHtmlViewerPanelListener.class) continue;
            if (evt == null) {
                evt = new HtmlViewerPanelListenerEvent(this);
            }
            ((IHtmlViewerPanelListener)listeners[i + 1]).currentURLHasChanged(evt);
        }
    }

    private void fireHomeURLChanged() {
        Object[] listeners = this._listenerList.getListenerList();
        HtmlViewerPanelListenerEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IHtmlViewerPanelListener.class) continue;
            if (evt == null) {
                evt = new HtmlViewerPanelListenerEvent(this);
            }
            ((IHtmlViewerPanelListener)listeners[i + 1]).homeURLHasChanged(evt);
        }
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createMainPanel(), "Center");
    }

    private JPanel createMainPanel() {
        this._contentsTxt.setEditable(false);
        this._contentsTxt.setContentType("text/html");
        final TextPopupMenu pop = new TextPopupMenu();
        pop.setTextComponent(this._contentsTxt);
        this._contentsTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    pop.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    pop.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        JPanel pnl = new JPanel(new BorderLayout());
        this._contentsTxt.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        this._contentsTxt.addHyperlinkListener(this.createHyperLinkListener());
        this._contentsScrollPane = new JScrollPane(this._contentsTxt, 22, 32);
        pnl.add((Component)this._contentsScrollPane, "Center");
        return pnl;
    }

    private HyperlinkListener createHyperLinkListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        ((HTMLDocument)HtmlViewerPanel.this._contentsTxt.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                    } else {
                        try {
                            HtmlViewerPanel.this.gotoURL(e.getURL());
                        }
                        catch (IOException ex) {
                            s_log.error(s_stringMgr.getString("HtmlViewerPanel.error.processhyperlink"), ex);
                        }
                    }
                }
            }
        };
    }
}

