/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.plaf.UIResource;

public class McWinIcons
extends BaseIcons {
    public static Icon getIconIcon() {
        if (iconIcon == null) {
            iconIcon = new BaseIcons.MacIconIcon();
        }
        return iconIcon;
    }

    public static Icon getMinIcon() {
        if (minIcon == null) {
            minIcon = new BaseIcons.MacMinIcon();
        }
        return minIcon;
    }

    public static Icon getMaxIcon() {
        if (maxIcon == null) {
            maxIcon = new BaseIcons.MacMaxIcon();
        }
        return maxIcon;
    }

    public static Icon getCloseIcon() {
        if (closeIcon == null) {
            closeIcon = new BaseIcons.MacCloseIcon();
        }
        return closeIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getThumbHorIcon() {
        if (thumbHorIcon == null) {
            thumbHorIcon = new ThumbIcon(false);
        }
        return thumbHorIcon;
    }

    public static Icon getThumbVerIcon() {
        if (thumbVerIcon == null) {
            thumbVerIcon = new ThumbIcon(false);
        }
        return thumbVerIcon;
    }

    public static Icon getThumbHorIconRollover() {
        if (thumbHorIconRollover == null) {
            thumbHorIconRollover = new ThumbIcon(true);
        }
        return thumbHorIconRollover;
    }

    public static Icon getThumbVerIconRollover() {
        if (thumbVerIconRollover == null) {
            thumbVerIconRollover = new ThumbIcon(true);
        }
        return thumbVerIconRollover;
    }

    private static class ThumbIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int WIDTH = 15;
        private static final int HEIGHT = 15;
        private boolean isRollover = false;

        public ThumbIcon(boolean isRollover) {
            this.isRollover = isRollover;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2D = (Graphics2D)g;
            Color[] colors = null;
            colors = this.isRollover ? AbstractLookAndFeel.getTheme().getRolloverColors() : (AbstractLookAndFeel.getTheme().isBrightMode() ? AbstractLookAndFeel.getTheme().getButtonColors() : AbstractLookAndFeel.getTheme().getSelectedColors());
            Shape savedClip = g2D.getClip();
            if (savedClip != null) {
                Area clipArea = new Area(new Ellipse2D.Double(x + 1, y + 1, 15.0, 15.0));
                clipArea.intersect(new Area(savedClip));
                g2D.setClip(clipArea);
                JTattooUtilities.fillHorGradient(g, colors, x + 1, y + 1, 15, 15);
                g2D.setClip(savedClip);
            } else {
                Area ellipseArea = new Area(new Ellipse2D.Double(x + 1, y + 1, 15.0, 15.0));
                g2D.setClip(ellipseArea);
                JTattooUtilities.fillHorGradient(g, colors, x, y, 15, 15);
                g2D.setClip(null);
            }
            g2D.setColor(AbstractLookAndFeel.getFrameColor());
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.drawOval(x + 1, y + 1, 14, 14);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
        }

        public int getIconWidth() {
            return 17;
        }

        public int getIconHeight() {
            return 17;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private static Icon radioIcon = new LazyImageIcon("mcwin/icons/RadioSymbol.gif");
        private static Icon radioDisabledIcon = new LazyImageIcon("mcwin/icons/RadioSymbolDisabled.gif");
        private static final int WIDTH = 14;
        private static final int HEIGHT = 14;

        private RadioButtonIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!JTattooUtilities.isLeftToRight(c)) {
                x += 3;
            }
            Graphics2D g2D = (Graphics2D)g;
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            Color[] colors = null;
            colors = button.isEnabled() ? (button.isRolloverEnabled() && model.isRollover() && !model.isArmed() ? AbstractLookAndFeel.getTheme().getRolloverColors() : (!JTattooUtilities.isFrameActive(button) ? AbstractLookAndFeel.getTheme().getInActiveColors() : (button.isSelected() ? AbstractLookAndFeel.getTheme().getDefaultColors() : AbstractLookAndFeel.getTheme().getButtonColors()))) : AbstractLookAndFeel.getTheme().getDisabledColors();
            Shape savedClip = g.getClip();
            Area clipArea = new Area(new Ellipse2D.Double(x, y, 15.0, 15.0));
            clipArea.intersect(new Area(savedClip));
            g2D.setClip(clipArea);
            JTattooUtilities.fillHorGradient(g, colors, x, y, 14, 14);
            g2D.setClip(savedClip);
            if (button.isEnabled()) {
                g2D.setColor(AbstractLookAndFeel.getFrameColor());
            } else {
                g2D.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 20.0));
            }
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.drawOval(x, y, 14, 14);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
            if (model.isSelected()) {
                int xi = x + (14 - radioIcon.getIconWidth()) / 2 + 1;
                int yi = y + (14 - radioIcon.getIconHeight()) / 2 + 1;
                if (model.isEnabled()) {
                    radioIcon.paintIcon(c, g, xi, yi);
                } else {
                    radioDisabledIcon.paintIcon(c, g, xi, yi);
                }
            }
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 14;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static Icon checkIcon = new LazyImageIcon("mcwin/icons/CheckSymbol.gif");
        private static Icon checkDisabledIcon = new LazyImageIcon("mcwin/icons/CheckSymbolDisabled.gif");
        private static Icon checkPressedIcon = new LazyImageIcon("mcwin/icons/CheckPressedSymbol.gif");
        private static final int WIDTH = 13;
        private static final int HEIGHT = 14;

        private CheckBoxIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!JTattooUtilities.isLeftToRight(c)) {
                x += 3;
            }
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            Color[] colors = null;
            if (button.isEnabled()) {
                colors = button.isRolloverEnabled() && model.isRollover() ? AbstractLookAndFeel.getTheme().getRolloverColors() : (!JTattooUtilities.isFrameActive(button) ? AbstractLookAndFeel.getTheme().getInActiveColors() : (button.isSelected() ? AbstractLookAndFeel.getTheme().getDefaultColors() : AbstractLookAndFeel.getTheme().getButtonColors()));
                JTattooUtilities.fillHorGradient(g, colors, x + 1, y + 1, 12, 13);
                g.setColor(AbstractLookAndFeel.getFrameColor());
                g.drawRect(x, y, 13, 14);
            } else {
                colors = AbstractLookAndFeel.getTheme().getDisabledColors();
                JTattooUtilities.fillHorGradient(g, colors, x + 1, y + 1, 12, 13);
                g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 20.0));
                g.drawRect(x, y, 13, 14);
            }
            if (button.isEnabled() && !model.isRollover() && !model.isPressed() && !model.isSelected()) {
                g.setColor(Color.white);
                g.drawLine(x + 1, y + 1, x + 1, y + 14 - 2);
                g.drawLine(x + 13 - 1, y + 1, x + 13 - 1, y + 14 - 2);
            }
            if (model.isPressed()) {
                int xi = x + (13 - checkPressedIcon.getIconWidth()) / 2 + 1;
                int yi = y + (14 - checkPressedIcon.getIconHeight()) / 2 + 1;
                checkPressedIcon.paintIcon(c, g, xi, yi);
            } else if (model.isSelected()) {
                int xi = x + (13 - checkIcon.getIconWidth()) / 2 + 1;
                int yi = y + (14 - checkIcon.getIconHeight()) / 2;
                if (model.isEnabled()) {
                    checkIcon.paintIcon(c, g, xi + 2, yi);
                } else {
                    checkDisabledIcon.paintIcon(c, g, xi + 2, yi);
                }
            }
        }

        public int getIconWidth() {
            return 19;
        }

        public int getIconHeight() {
            return 14;
        }
    }
}

