/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre.core.time;

import java.util.HashMap;
import java.util.Map;

public enum TimephasedType {
    REMAINING_WORK(1, 11),
    ACTUAL_WORK(2, 11),
    ACTUAL_OVERTIME_WORK(3, 11),
    BASELINE_WORK(4, 0),
    BASELINE_COST(5, 0),
    ACTUAL_COST(6, 11),
    BASELINE1_WORK(16, 1),
    BASELINE1_COST(17, 1),
    BASELINE2_WORK(22, 2),
    BASELINE2_COST(23, 2),
    BASELINE3_WORK(28, 3),
    BASELINE3_COST(29, 3),
    BASELINE4_WORK(34, 4),
    BASELINE4_COST(35, 4),
    BASELINE5_WORK(40, 5),
    BASELINE5_COST(41, 5),
    BASELINE6_WORK(46, 6),
    BASELINE6_COST(47, 6),
    BASELINE7_WORK(52, 7),
    BASELINE7_COST(53, 7),
    BASELINE8_WORK(58, 8),
    BASELINE8_COST(59, 8),
    BASELINE9_WORK(64, 9),
    BASELINE9_COST(65, 9),
    BASELINE10_WORK(70, 10),
    BASELINE10_COST(71, 10);

    protected int id;
    protected int snapshotId;
    protected static Map<Integer, TimephasedType> reverseMap;

    private TimephasedType(int n2, int n3) {
        this.id = n2;
        this.snapshotId = n3;
    }

    public int getId() {
        return this.id;
    }

    public int getSnapshotId() {
        return this.snapshotId;
    }

    public static TimephasedType getInstance(int n) {
        if (reverseMap == null) {
            reverseMap = new HashMap<Integer, TimephasedType>();
            for (TimephasedType timephasedType : TimephasedType.values()) {
                reverseMap.put(timephasedType.getId(), timephasedType);
            }
        }
        return reverseMap.get(n);
    }

    public boolean isWork() {
        return this == REMAINING_WORK || this == ACTUAL_WORK || this == ACTUAL_OVERTIME_WORK || this == BASELINE_WORK || this == BASELINE1_WORK || this == BASELINE2_WORK || this == BASELINE3_WORK || this == BASELINE4_WORK || this == BASELINE5_WORK || this == BASELINE6_WORK || this == BASELINE7_WORK || this == BASELINE8_WORK || this == BASELINE9_WORK || this == BASELINE10_WORK;
    }
}

