/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.diff.myers;

import org.apache.commons.jrcs.diff.Chunk;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.DiffAlgorithm;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.Revision;
import org.apache.commons.jrcs.diff.myers.DiffNode;
import org.apache.commons.jrcs.diff.myers.PathNode;
import org.apache.commons.jrcs.diff.myers.Snake;

public class MyersDiff
implements DiffAlgorithm {
    public Revision diff(Object[] objectArray, Object[] objectArray2) throws DifferentiationFailedException {
        PathNode pathNode = MyersDiff.buildPath(objectArray, objectArray2);
        return MyersDiff.buildRevision(pathNode, objectArray, objectArray2);
    }

    public static PathNode buildPath(Object[] objectArray, Object[] objectArray2) throws DifferentiationFailedException {
        if (objectArray == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (objectArray2 == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        int n = objectArray.length;
        int n2 = objectArray2.length;
        int n3 = n + n2 + 1;
        int n4 = 1 + 2 * n3;
        int n5 = (n4 + 1) / 2;
        PathNode[] pathNodeArray = new PathNode[n4];
        Object var8_8 = null;
        pathNodeArray[n5 + 1] = new Snake(0, -1, null);
        for (int i = 0; i < n3; ++i) {
            for (int j = -i; j <= i; j += 2) {
                int n6;
                int n7;
                int n8 = n5 + j;
                int n9 = n8 + 1;
                int n10 = n8 - 1;
                PathNode pathNode = null;
                if (j == -i || j != i && pathNodeArray[n10].i < pathNodeArray[n9].i) {
                    n7 = pathNodeArray[n9].i;
                    pathNode = pathNodeArray[n9];
                } else {
                    n7 = pathNodeArray[n10].i + 1;
                    pathNode = pathNodeArray[n10];
                }
                pathNodeArray[n10] = null;
                PathNode pathNode2 = new DiffNode(n7, n6, pathNode);
                for (n6 = n7 - j; n7 < n && n6 < n2 && objectArray[n7].equals(objectArray2[n6]); ++n7, ++n6) {
                }
                if (n7 > pathNode2.i) {
                    pathNode2 = new Snake(n7, n6, pathNode2);
                }
                pathNodeArray[n8] = pathNode2;
                if (n7 < n || n6 < n2) continue;
                return pathNodeArray[n8];
            }
            pathNodeArray[n5 + i - 1] = null;
        }
        throw new DifferentiationFailedException("could not find a diff path");
    }

    public static Revision buildRevision(PathNode pathNode, Object[] objectArray, Object[] objectArray2) {
        if (pathNode == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (objectArray == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (objectArray2 == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        Revision revision = new Revision();
        if (pathNode.isSnake()) {
            pathNode = pathNode.prev;
        }
        while (pathNode != null && pathNode.prev != null && pathNode.prev.j >= 0) {
            if (pathNode.isSnake()) {
                throw new IllegalStateException("bad diffpath: found snake when looking for diff");
            }
            int n = pathNode.i;
            int n2 = pathNode.j;
            pathNode = pathNode.prev;
            int n3 = pathNode.i;
            int n4 = pathNode.j;
            Delta delta = Delta.newDelta(new Chunk(objectArray, n3, n - n3), new Chunk(objectArray2, n4, n2 - n4));
            revision.insertDelta(delta);
            if (!pathNode.isSnake()) continue;
            pathNode = pathNode.prev;
        }
        return revision;
    }
}

