/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.converter;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBlockBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirComponentCallBuilder;
import org.jetbrains.kotlin.fir.lightTree.fir.DestructuringDeclaration;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a/\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0019\u0010\u0010\u001a\u0015\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0011\u00a2\u0006\u0002\b\u0012H\u0086\b\u00f8\u0001\u0000\u001a'\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u0015*\u0002H\u00142\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0002\u0010\u0018\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\u000f\u001a\u0016\u0010\u001b\u001a\u00020\u001c*\u0004\u0018\u00010\u001a2\b\b\u0002\u0010\u001d\u001a\u00020\u001a\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001e"}, d2={"isUnderscored", "", "Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;", "(Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;)Z", "generateDestructuringBlock", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "multiDeclaration", "Lorg/jetbrains/kotlin/fir/lightTree/fir/DestructuringDeclaration;", "container", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "tmpVariable", "isClassLocal", "classNode", "Lcom/intellij/lang/LighterASTNode;", "getParent", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "extractArgumentsFrom", "T", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;Ljava/util/List;)Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;", "getAsStringWithoutBacktick", "", "nameAsSafeName", "Lorg/jetbrains/kotlin/name/Name;", "defaultName", "light-tree2fir"})
public final class ConverterUtilKt {
    @NotNull
    public static final Name nameAsSafeName(@Nullable String $this$nameAsSafeName, @NotNull String defaultName) {
        Name name;
        Intrinsics.checkNotNullParameter(defaultName, "defaultName");
        String string2 = $this$nameAsSafeName;
        if (string2 != null) {
            Name name2 = Name.identifier(KtPsiUtil.unquoteIdentifier(string2));
            name = name2;
            Intrinsics.checkNotNullExpressionValue(name2, "identifier(KtPsiUtil.unquoteIdentifier(this))");
        } else if (((CharSequence)defaultName).length() > 0) {
            Name name3 = Name.identifier(defaultName);
            name = name3;
            Intrinsics.checkNotNullExpressionValue(name3, "identifier(defaultName)");
        } else {
            name = SpecialNames.NO_NAME_PROVIDED;
        }
        return name;
    }

    public static /* synthetic */ Name nameAsSafeName$default(String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string3 = "";
        }
        return ConverterUtilKt.nameAsSafeName(string2, string3);
    }

    @NotNull
    public static final String getAsStringWithoutBacktick(@NotNull LighterASTNode $this$getAsStringWithoutBacktick) {
        Intrinsics.checkNotNullParameter($this$getAsStringWithoutBacktick, "<this>");
        return StringsKt.replace$default($this$getAsStringWithoutBacktick.toString(), "`", "", false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends FirCallBuilder> T extractArgumentsFrom(@NotNull T $this$extractArgumentsFrom, @NotNull List<? extends FirExpression> container) {
        void $this$extractArgumentsFrom_u24lambda_u240;
        FirArgumentListBuilder firArgumentListBuilder;
        Intrinsics.checkNotNullParameter($this$extractArgumentsFrom, "<this>");
        Intrinsics.checkNotNullParameter(container, "container");
        boolean $i$f$buildArgumentList = false;
        FirArgumentListBuilder firArgumentListBuilder2 = firArgumentListBuilder = new FirArgumentListBuilder();
        T t = $this$extractArgumentsFrom;
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$extractArgumentsFrom_u24lambda_u240.getArguments(), (Iterable)container);
        t.setArgumentList(firArgumentListBuilder.build());
        return $this$extractArgumentsFrom;
    }

    public static final boolean isClassLocal(@NotNull LighterASTNode classNode, @NotNull Function1<? super LighterASTNode, ? extends LighterASTNode> getParent) {
        Intrinsics.checkNotNullParameter(classNode, "classNode");
        Intrinsics.checkNotNullParameter(getParent, "getParent");
        boolean $i$f$isClassLocal = false;
        LighterASTNode currentNode = classNode;
        while (currentNode != null) {
            IElementType parentTokenType;
            LighterASTNode parent2;
            IElementType tokenType = currentNode.getTokenType();
            LighterASTNode lighterASTNode2 = parent2 = getParent.invoke(currentNode);
            IElementType iElementType = parentTokenType = lighterASTNode2 != null ? lighterASTNode2.getTokenType() : null;
            if (Intrinsics.areEqual(tokenType, KtNodeTypes.PROPERTY) || Intrinsics.areEqual(tokenType, KtNodeTypes.FUN)) {
                LighterASTNode lighterASTNode3 = parent2;
                LighterASTNode grandParent = lighterASTNode3 != null ? getParent.invoke(lighterASTNode3) : null;
                if (Intrinsics.areEqual(parentTokenType, KtNodeTypes.KT_FILE)) {
                    return true;
                }
                if (Intrinsics.areEqual(parentTokenType, KtNodeTypes.CLASS_BODY)) {
                    LighterASTNode lighterASTNode4;
                    LighterASTNode lighterASTNode5 = grandParent;
                    if (!Intrinsics.areEqual(lighterASTNode5 != null ? lighterASTNode5.getTokenType() : null, KtNodeTypes.OBJECT_DECLARATION) || !Intrinsics.areEqual((lighterASTNode4 = grandParent) != null && (lighterASTNode4 = getParent.invoke(lighterASTNode4)) != null ? lighterASTNode4.getTokenType() : null, KtNodeTypes.OBJECT_LITERAL)) {
                        return true;
                    }
                }
                if (Intrinsics.areEqual(parentTokenType, KtNodeTypes.BLOCK)) {
                    LighterASTNode lighterASTNode6 = grandParent;
                    if (Intrinsics.areEqual(lighterASTNode6 != null ? lighterASTNode6.getTokenType() : null, KtNodeTypes.SCRIPT)) {
                        return true;
                    }
                }
            }
            if (Intrinsics.areEqual(parentTokenType, KtNodeTypes.ENUM_ENTRY)) {
                return true;
            }
            if (Intrinsics.areEqual(tokenType, KtNodeTypes.BLOCK)) {
                return true;
            }
            currentNode = parent2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirBlock generateDestructuringBlock(@NotNull FirModuleData moduleData, @NotNull DestructuringDeclaration multiDeclaration, @NotNull FirVariable container, boolean tmpVariable) {
        FirBlockBuilder firBlockBuilder;
        Intrinsics.checkNotNullParameter(moduleData, "moduleData");
        Intrinsics.checkNotNullParameter(multiDeclaration, "multiDeclaration");
        Intrinsics.checkNotNullParameter(container, "container");
        boolean $i$f$buildBlock = false;
        FirBlockBuilder $this$generateDestructuringBlock_u24lambda_u243 = firBlockBuilder = new FirBlockBuilder();
        boolean bl = false;
        if (tmpVariable) {
            ((Collection)$this$generateDestructuringBlock_u24lambda_u243.getStatements()).add(container);
        }
        boolean isVar = multiDeclaration.isVar();
        Iterator<FirVariable> iterator2 = multiDeclaration.getEntries().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            void $this$generateDestructuringBlock_u24lambda_u243_u24lambda_u242_u24lambda_u241;
            FirComponentCallBuilder firComponentCallBuilder;
            FirPropertyBuilder firPropertyBuilder;
            int index2 = n++;
            FirVariable entry = iterator2.next();
            if (entry == null) continue;
            Collection collection = $this$generateDestructuringBlock_u24lambda_u243.getStatements();
            boolean $i$f$buildProperty = false;
            FirPropertyBuilder $this$generateDestructuringBlock_u24lambda_u243_u24lambda_u242 = firPropertyBuilder = new FirPropertyBuilder();
            boolean bl2 = false;
            $this$generateDestructuringBlock_u24lambda_u243_u24lambda_u242.setModuleData(moduleData);
            $this$generateDestructuringBlock_u24lambda_u243_u24lambda_u242.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateDestructuringBlock_u24lambda_u243_u24lambda_u242.setReturnTypeRef(entry.getReturnTypeRef());
            $this$generateDestructuringBlock_u24lambda_u243_u24lambda_u242.setName(entry.getName());
            boolean $i$f$buildComponentCall = false;
            FirComponentCallBuilder firComponentCallBuilder2 = firComponentCallBuilder = new FirComponentCallBuilder();
            FirPropertyBuilder firPropertyBuilder2 = $this$generateDestructuringBlock_u24lambda_u243_u24lambda_u242;
            boolean bl3 = false;
            KtSourceElement ktSourceElement = entry.getSource();
            KtSourceElement componentCallSource = ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.DesugaredComponentFunctionCall.INSTANCE) : null;
            $this$generateDestructuringBlock_u24lambda_u243_u24lambda_u242_u24lambda_u241.setSource(componentCallSource);
            $this$generateDestructuringBlock_u24lambda_u243_u24lambda_u242_u24lambda_u241.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(componentCallSource, container));
            $this$generateDestructuringBlock_u24lambda_u243_u24lambda_u242_u24lambda_u241.setComponentIndex(index2 + 1);
            firPropertyBuilder2.setInitializer(firComponentCallBuilder.build());
            $this$generateDestructuringBlock_u24lambda_u243_u24lambda_u242.setVar(isVar);
            $this$generateDestructuringBlock_u24lambda_u243_u24lambda_u242.setSymbol(new FirPropertySymbol(entry.getName()));
            $this$generateDestructuringBlock_u24lambda_u243_u24lambda_u242.setSource(entry.getSource());
            $this$generateDestructuringBlock_u24lambda_u243_u24lambda_u242.setLocal(true);
            $this$generateDestructuringBlock_u24lambda_u243_u24lambda_u242.setStatus(new FirDeclarationStatusImpl(Visibilities.Local.INSTANCE, Modality.FINAL));
            CollectionsKt.addAll((Collection)$this$generateDestructuringBlock_u24lambda_u243_u24lambda_u242.getAnnotations(), (Iterable)entry.getAnnotations());
            FirProperty firProperty = firPropertyBuilder.build();
            collection.add(firProperty);
        }
        return firBlockBuilder.build();
    }

    public static final boolean isUnderscored(@NotNull FirUserTypeRef $this$isUnderscored) {
        Intrinsics.checkNotNullParameter($this$isUnderscored, "<this>");
        Object object = CollectionsKt.lastOrNull($this$isUnderscored.getQualifier());
        return Intrinsics.areEqual(object != null && (object = object.getName()) != null ? ((Name)object).asString() : null, "_");
    }
}

