/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrLocalDelegatedPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002*+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0012J(\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J@\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u001e0\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001e2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u001aH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmPropertyReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "getSymbols", "()Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "tempIndex", "", "createKProperty", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "kTypeGenerator", "Lorg/jetbrains/kotlin/backend/wasm/lower/WasmPropertyReferenceLowering$KTypeGeneratorInterface;", "irBuilder", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "createKTypeGenerator", "createLocalKProperty", "propertyName", "", "propertyType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getKPropertyImplConstructor", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "", "receiverTypes", "returnType", "isLocal", "", "isMutable", "isKMutablePropertyType", "type", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "DECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION", "KTypeGeneratorInterface", "backend.wasm"})
public final class WasmPropertyReferenceLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    private int tempIndex;
    @NotNull
    private final WasmSymbols symbols;

    public WasmPropertyReferenceLowering(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.symbols = this.context.getWasmSymbols();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final WasmSymbols getSymbols() {
        return this.symbols;
    }

    @NotNull
    public final KTypeGeneratorInterface createKTypeGenerator() {
        return (arg_0, arg_1) -> WasmPropertyReferenceLowering.createKTypeGenerator$lambda$0(this, arg_0, arg_1);
    }

    private final Pair<IrConstructorSymbol, List<IrType>> getKPropertyImplConstructor(List<? extends IrType> receiverTypes, IrType returnType2, boolean isLocal, boolean isMutable) {
        IrClassSymbol irClassSymbol;
        if (isLocal) {
            boolean bl = receiverTypes.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Local delegated property cannot have explicit receiver";
                throw new AssertionError((Object)string2);
            }
            irClassSymbol = isMutable ? this.symbols.getKLocalDelegatedMutablePropertyImpl() : this.symbols.getKLocalDelegatedPropertyImpl();
        } else {
            switch (receiverTypes.size()) {
                case 0: {
                    if (isMutable) {
                        irClassSymbol = this.symbols.getKMutableProperty0Impl();
                        break;
                    }
                    irClassSymbol = this.symbols.getKProperty0Impl();
                    break;
                }
                case 1: {
                    if (isMutable) {
                        irClassSymbol = this.symbols.getKMutableProperty1Impl();
                        break;
                    }
                    irClassSymbol = this.symbols.getKProperty1Impl();
                    break;
                }
                case 2: {
                    if (isMutable) {
                        irClassSymbol = this.symbols.getKMutableProperty2Impl();
                        break;
                    }
                    irClassSymbol = this.symbols.getKProperty2Impl();
                    break;
                }
                default: {
                    throw new IllegalStateException("More than 2 receivers is not allowed".toString());
                }
            }
        }
        IrClassSymbol classSymbol = irClassSymbol;
        List arguments2 = CollectionsKt.plus((Collection)receiverTypes, (Iterable)CollectionsKt.listOf(returnType2));
        return TuplesKt.to(SequencesKt.single(IrUtilsKt.getConstructors(classSymbol)), arguments2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        Map kProperties = new LinkedHashMap();
        IrClass arrayClass = (IrClass)this.context.getIrBuiltIns().getArrayClass().getOwner();
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(arrayClass);
        boolean $i$f$single = false;
        IrType[] single$iv = null;
        boolean found$iv22 = false;
        Object object = $this$single$iv.iterator();
        while (object.hasNext()) {
            IrSimpleFunction element$iv;
            IrSimpleFunction it = element$iv = object.next();
            boolean bl2 = false;
            if (!Intrinsics.areEqual(it.getName(), Name.identifier("get"))) continue;
            if (found$iv22) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv22 = true;
        }
        if (!found$iv22) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction arrayItemGetter = (IrSimpleFunction)single$iv;
        IrType anyType = this.context.getIrBuiltIns().getAnyType();
        single$iv = new IrType[]{anyType, anyType};
        IrSimpleType kPropertyImplType = IrTypesKt.typeWith((IrClassifierSymbol)this.symbols.getKProperty1Impl(), single$iv);
        IrType[] found$iv22 = new IrType[]{kPropertyImplType};
        IrType kPropertiesFieldType = IrTypesKt.typeWith(arrayClass, found$iv22);
        IrFactory irFactory = this.context.getIrFactory();
        IrDeclarationOrigin irDeclarationOrigin = DECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION.INSTANCE;
        IrFieldSymbol irFieldSymbol = new IrFieldSymbolImpl(null, 1, null);
        Name name = Name.identifier("$KPROPERTIES");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(\"\\$KPROPERTIES\")");
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PRIVATE");
        Object $this$lower_u24lambda_u243 = object = irFactory.createField(-2, -2, irDeclarationOrigin, irFieldSymbol, name, kPropertiesFieldType, descriptorVisibility, true, false, true);
        boolean bl = false;
        $this$lower_u24lambda_u243.setParent(irFile);
        Object kPropertiesField = object;
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoidWithContext(this, kProperties, arrayItemGetter, (IrField)kPropertiesField){
            final /* synthetic */ WasmPropertyReferenceLowering this$0;
            final /* synthetic */ Map<IrDeclaration, Pair<IrExpression, Integer>> $kProperties;
            final /* synthetic */ IrSimpleFunction $arrayItemGetter;
            final /* synthetic */ IrField $kPropertiesField;
            {
                this.this$0 = $receiver;
                this.$kProperties = $kProperties;
                this.$arrayItemGetter = $arrayItemGetter;
                this.$kPropertiesField = $kPropertiesField;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitPropertyReference(@NotNull IrPropertyReference expression2) {
                IrExpression irExpression;
                int n;
                DeclarationIrBuilder irBuilder;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                KTypeGeneratorInterface kTypeGenerator = this.this$0.createKTypeGenerator();
                int startOffset = expression2.getStartOffset();
                int endOffset = expression2.getEndOffset();
                BackendContext backendContext = this.this$0.getContext();
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull(scopeWithIr);
                DeclarationIrBuilder declarationIrBuilder = irBuilder = LowerUtilsKt.createIrBuilder(backendContext, scopeWithIr.getScope().getScopeOwnerSymbol(), startOffset, endOffset);
                Map<IrDeclaration, Pair<IrExpression, Integer>> map = this.$kProperties;
                IrSimpleFunction irSimpleFunction = this.$arrayItemGetter;
                WasmPropertyReferenceLowering wasmPropertyReferenceLowering = this.this$0;
                IrField irField = this.$kPropertiesField;
                DeclarationIrBuilder $this$visitPropertyReference_u24lambda_u243 = declarationIrBuilder;
                boolean bl = false;
                IrExpression[] irExpressionArray = new IrExpression[]{expression2.getDispatchReceiver(), expression2.getExtensionReceiver()};
                Iterable $this$count$iv = CollectionsKt.listOf(irExpressionArray);
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        IrExpression it = (IrExpression)element$iv;
                        boolean bl2 = false;
                        if (!(it != null) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int receiversCount = n;
                switch (receiversCount) {
                    case 0: {
                        IrFunctionAccessExpression irFunctionAccessExpression;
                        Object object;
                        void $this$getOrPut$iv;
                        Map<IrDeclaration, Pair<IrExpression, Integer>> count$iv = map;
                        B key$iv = ((IrPropertySymbol)expression2.getSymbol()).getOwner();
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl3 = false;
                            Pair<IrExpression, Integer> answer$iv = TuplesKt.to(WasmPropertyReferenceLowering.access$createKProperty(wasmPropertyReferenceLowering, expression2, kTypeGenerator, $this$visitPropertyReference_u24lambda_u243), map.size());
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        Pair field2 = (Pair)object;
                        IrFunctionAccessExpression $this$visitPropertyReference_u24lambda_u243_u24lambda_u242 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$visitPropertyReference_u24lambda_u243, irSimpleFunction);
                        boolean bl4 = false;
                        $this$visitPropertyReference_u24lambda_u243_u24lambda_u242.setDispatchReceiver(ExpressionHelpersKt.irGetField($this$visitPropertyReference_u24lambda_u243, null, irField));
                        $this$visitPropertyReference_u24lambda_u243_u24lambda_u242.putValueArgument(0, ExpressionHelpersKt.irInt$default($this$visitPropertyReference_u24lambda_u243, ((Number)field2.getSecond()).intValue(), null, 2, null));
                        irExpression = irFunctionAccessExpression;
                        break;
                    }
                    case 1: {
                        irExpression = WasmPropertyReferenceLowering.access$createKProperty(wasmPropertyReferenceLowering, expression2, kTypeGenerator, $this$visitPropertyReference_u24lambda_u243);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(("Callable reference to properties with two receivers is not allowed: " + ((IrProperty)((IrPropertySymbol)expression2.getSymbol()).getOwner()).getName()).toString());
                    }
                }
                return irExpression;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                IrFunctionAccessExpression irFunctionAccessExpression;
                Object object;
                void $this$getOrPut$iv;
                int receiversCount;
                int n;
                DeclarationIrBuilder irBuilder;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                int startOffset = expression2.getStartOffset();
                int endOffset = expression2.getEndOffset();
                BackendContext backendContext = this.this$0.getContext();
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull(scopeWithIr);
                DeclarationIrBuilder declarationIrBuilder = irBuilder = LowerUtilsKt.createIrBuilder(backendContext, scopeWithIr.getScope().getScopeOwnerSymbol(), startOffset, endOffset);
                Map<IrDeclaration, Pair<IrExpression, Integer>> map = this.$kProperties;
                IrSimpleFunction irSimpleFunction = this.$arrayItemGetter;
                WasmPropertyReferenceLowering wasmPropertyReferenceLowering = this.this$0;
                IrField irField = this.$kPropertiesField;
                DeclarationIrBuilder $this$visitLocalDelegatedPropertyReference_u24lambda_u247 = declarationIrBuilder;
                boolean bl = false;
                IrExpression[] irExpressionArray = new IrExpression[]{expression2.getDispatchReceiver(), expression2.getExtensionReceiver()};
                Iterable $this$count$iv = CollectionsKt.listOf(irExpressionArray);
                boolean $i$f$count22 = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        IrExpression it = (IrExpression)element$iv;
                        boolean bl2 = false;
                        if (!(it != null) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = receiversCount = count$iv;
                }
                if (receiversCount == 2) {
                    throw new IllegalStateException(("Callable reference to properties with two receivers is not allowed: " + expression2).toString());
                }
                Map<IrDeclaration, Pair<IrExpression, Integer>> $i$f$count22 = map;
                B key$iv = ((IrLocalDelegatedPropertySymbol)expression2.getSymbol()).getOwner();
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    String string2 = ((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)expression2.getSymbol()).getOwner()).getName().asString();
                    Intrinsics.checkNotNullExpressionValue(string2, "expression.symbol.owner.name.asString()");
                    Pair<IrExpression, Integer> answer$iv = TuplesKt.to(WasmPropertyReferenceLowering.access$createLocalKProperty(wasmPropertyReferenceLowering, string2, ((IrSimpleFunction)expression2.getGetter().getOwner()).getReturnType(), wasmPropertyReferenceLowering.createKTypeGenerator(), $this$visitLocalDelegatedPropertyReference_u24lambda_u247), map.size());
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Pair field2 = (Pair)object;
                IrFunctionAccessExpression $this$visitLocalDelegatedPropertyReference_u24lambda_u247_u24lambda_u246 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$visitLocalDelegatedPropertyReference_u24lambda_u247, irSimpleFunction);
                boolean bl4 = false;
                $this$visitLocalDelegatedPropertyReference_u24lambda_u247_u24lambda_u246.setDispatchReceiver(ExpressionHelpersKt.irGetField($this$visitLocalDelegatedPropertyReference_u24lambda_u247, null, irField));
                $this$visitLocalDelegatedPropertyReference_u24lambda_u247_u24lambda_u246.putValueArgument(0, ExpressionHelpersKt.irInt$default($this$visitLocalDelegatedPropertyReference_u24lambda_u247, ((Number)field2.getSecond()).intValue(), null, 2, null));
                return irFunctionAccessExpression;
            }
        });
        if (!kProperties.isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $this$sortedBy$iv = kProperties.values();
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getSecond();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getSecond()));
                }
            });
            boolean $i$f$map = false;
            void bl2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add((IrExpression)it.getFirst());
            }
            List initializers = (List)destination$iv$iv;
            ((IrField)kPropertiesField).setInitializer(this.context.getIrFactory().createExpressionBody(-2, -2, org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createArrayOfExpression(this.context, -2, -2, kPropertyImplType, initializers)));
            irFile.getDeclarations().add(0, (IrDeclaration)kPropertiesField);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression createKProperty(IrPropertyReference expression2, KTypeGeneratorInterface kTypeGenerator, IrBuilderWithScope irBuilder) {
        void $this$createKProperty_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418;
        IrMemberAccessExpression<?> irMemberAccessExpression;
        Object object;
        Object object2;
        IrElementBase getterCallableReference;
        IrElementBase irElementBase;
        IrElementBase irElementBase2;
        Object getterKFunctionType;
        Object object3;
        Object returnType2;
        Object object4;
        IrVariable extensionReceiver;
        IrVariable irVariable2;
        IrVariable irVariable3;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlock$iv$iv;
        int startOffset = expression2.getStartOffset();
        int endOffset = expression2.getEndOffset();
        IrGeneratorWithScope $this$irBlock_u24default$iv = irBuilder;
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = ((IrExpression)expression2).getType();
        boolean $i$f$irBlock = false;
        IrGeneratorWithScope irGeneratorWithScope = $this$irBlock_u24default$iv;
        int n = ((IrExpression)expression2).getStartOffset();
        int endOffset$iv$iv = ((IrExpression)expression2).getEndOffset();
        boolean $i$f$irBlock2 = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$createKProperty_u24lambda_u2420 = this_$iv$iv$iv;
        boolean bl = false;
        List receiverTypes = new ArrayList();
        IrExpression irExpression = expression2.getDispatchReceiver();
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl2 = false;
            int n2 = this.tempIndex;
            this.tempIndex = n2 + 1;
            irVariable3 = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$createKProperty_u24lambda_u2420, it, "$dispatchReceiver" + n2, null, false, 12, null);
        } else {
            irVariable3 = null;
        }
        IrVariable dispatchReceiver = irVariable3;
        IrExpression irExpression2 = expression2.getExtensionReceiver();
        if (irExpression2 != null) {
            IrExpression it = irExpression2;
            boolean bl3 = false;
            int n3 = this.tempIndex;
            this.tempIndex = n3 + 1;
            irVariable2 = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$createKProperty_u24lambda_u2420, it, "$extensionReceiver" + n3, null, false, 12, null);
        } else {
            irVariable2 = extensionReceiver = null;
        }
        if ((object4 = expression2.getGetter()) == null || (object4 = (IrSimpleFunction)object4.getOwner()) == null || (object4 = ((IrFunction)object4).getReturnType()) == null) {
            IrFieldSymbol irFieldSymbol = expression2.getField();
            Intrinsics.checkNotNull(irFieldSymbol);
            object4 = returnType2 = ((IrField)irFieldSymbol.getOwner()).getType();
        }
        if ((object3 = expression2.getGetter()) != null && (object3 = (IrSimpleFunction)object3.getOwner()) != null) {
            IrGetValueImpl irGetValueImpl;
            IrGetValueImpl irGetValueImpl2;
            IrVariable it;
            Object getter2 = object3;
            boolean bl4 = false;
            IrElementBase it2 = ((IrFunction)getter2).getExtensionReceiverParameter();
            boolean bl5 = false;
            if (it2 != null && expression2.getExtensionReceiver() == null) {
                receiverTypes.add(it2.getType());
            }
            it2 = ((IrFunction)getter2).getDispatchReceiverParameter();
            boolean bl6 = false;
            if (it2 != null && expression2.getDispatchReceiver() == null) {
                receiverTypes.add(it2.getType());
            }
            getterKFunctionType = IrUtilsKt.getKFunctionType(this.context.getIrBuiltIns(), (IrType)returnType2, receiverTypes);
            IrType irType = (IrType)getterKFunctionType;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getGetter();
            Intrinsics.checkNotNull(irSimpleFunctionSymbol);
            IrFunctionSymbol irFunctionSymbol = irSimpleFunctionSymbol;
            int n4 = getter2.getTypeParameters().size();
            int n5 = ((IrFunction)getter2).getValueParameters().size();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = expression2.getGetter();
            Intrinsics.checkNotNull(irSimpleFunctionSymbol2);
            IrElementBase $this$createKProperty_u24lambda_u2420_u24lambda_u2413_u24lambda_u2412 = it2 = new IrFunctionReferenceImpl(startOffset, endOffset, irType, irFunctionSymbol, n4, n5, irSimpleFunctionSymbol2, null, 128, null);
            boolean bl7 = false;
            IrElementBase irElementBase3 = $this$createKProperty_u24lambda_u2420_u24lambda_u2413_u24lambda_u2412;
            IrVariable irVariable4 = dispatchReceiver;
            if (irVariable4 != null) {
                IrVariable irVariable5 = irVariable4;
                irElementBase2 = irElementBase3;
                boolean bl8 = false;
                irGetValueImpl2 = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createKProperty_u24lambda_u2420, it);
                irElementBase3 = irElementBase2;
            } else {
                irGetValueImpl2 = null;
            }
            ((IrMemberAccessExpression)irElementBase3).setDispatchReceiver(irGetValueImpl2);
            IrElementBase irElementBase4 = $this$createKProperty_u24lambda_u2420_u24lambda_u2413_u24lambda_u2412;
            IrVariable irVariable6 = extensionReceiver;
            if (irVariable6 != null) {
                it = irVariable6;
                irElementBase2 = irElementBase4;
                boolean bl9 = false;
                irGetValueImpl = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createKProperty_u24lambda_u2420, it);
                irElementBase4 = irElementBase2;
            } else {
                irGetValueImpl = null;
            }
            ((IrMemberAccessExpression)irElementBase4).setExtensionReceiver(irGetValueImpl);
            int it3 = expression2.getTypeArgumentsCount();
            for (int index2 = 0; index2 < it3; ++index2) {
                ((IrMemberAccessExpression)$this$createKProperty_u24lambda_u2420_u24lambda_u2413_u24lambda_u2412).putTypeArgument(index2, expression2.getTypeArgument(index2));
            }
            irElementBase = it2;
        } else {
            irElementBase = getterCallableReference = null;
        }
        if ((object2 = expression2.getSetter()) != null && (object2 = (IrSimpleFunction)object2.getOwner()) != null) {
            Object setter2 = object2;
            boolean bl10 = false;
            if (!this.isKMutablePropertyType(expression2.getType())) {
                object = null;
            } else {
                IrGetValueImpl irGetValueImpl;
                IrGetValueImpl irGetValueImpl3;
                IrVariable it;
                IrSimpleType setterKFunctionType = IrUtilsKt.getKFunctionType(this.context.getIrBuiltIns(), $this$createKProperty_u24lambda_u2420.getContext().getIrBuiltIns().getUnitType(), CollectionsKt.plus((Collection)receiverTypes, returnType2));
                IrType irType = setterKFunctionType;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getSetter();
                Intrinsics.checkNotNull(irSimpleFunctionSymbol);
                IrFunctionSymbol irFunctionSymbol = irSimpleFunctionSymbol;
                int n6 = setter2.getTypeParameters().size();
                int n7 = ((IrFunction)setter2).getValueParameters().size();
                IrSimpleFunctionSymbol irSimpleFunctionSymbol3 = expression2.getSetter();
                Intrinsics.checkNotNull(irSimpleFunctionSymbol3);
                Object $this$createKProperty_u24lambda_u2420_u24lambda_u2417_u24lambda_u2416 = getterKFunctionType = new IrFunctionReferenceImpl(startOffset, endOffset, irType, irFunctionSymbol, n6, n7, irSimpleFunctionSymbol3, null, 128, null);
                boolean bl11 = false;
                Object object5 = $this$createKProperty_u24lambda_u2420_u24lambda_u2417_u24lambda_u2416;
                IrVariable irVariable7 = dispatchReceiver;
                if (irVariable7 != null) {
                    irElementBase2 = irVariable7;
                    Object object6 = object5;
                    boolean bl12 = false;
                    irGetValueImpl3 = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createKProperty_u24lambda_u2420, it);
                    object5 = object6;
                } else {
                    irGetValueImpl3 = null;
                }
                ((IrMemberAccessExpression)object5).setDispatchReceiver(irGetValueImpl3);
                Object object7 = $this$createKProperty_u24lambda_u2420_u24lambda_u2417_u24lambda_u2416;
                IrVariable irVariable8 = extensionReceiver;
                if (irVariable8 != null) {
                    it = irVariable8;
                    Object object8 = object7;
                    boolean bl13 = false;
                    irGetValueImpl = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createKProperty_u24lambda_u2420, it);
                    object7 = object8;
                } else {
                    irGetValueImpl = null;
                }
                ((IrMemberAccessExpression)object7).setExtensionReceiver(irGetValueImpl);
                int n8 = expression2.getTypeArgumentsCount();
                for (int index3 = 0; index3 < n8; ++index3) {
                    ((IrMemberAccessExpression)$this$createKProperty_u24lambda_u2420_u24lambda_u2417_u24lambda_u2416).putTypeArgument(index3, expression2.getTypeArgument(index3));
                }
                object = getterKFunctionType;
            }
        } else {
            object = null;
        }
        Object setterCallableReference = object;
        Pair<IrConstructorSymbol, List<IrType>> pair = this.getKPropertyImplConstructor(receiverTypes, (IrType)returnType2, false, setterCallableReference != null);
        IrConstructorSymbol symbol2 = pair.component1();
        List<IrType> constructorTypeArguments = pair.component2();
        IrSimpleType initializerType = IrTypesKt.typeWith(IrTypesKt.getClassifierOrFail(((IrConstructor)symbol2.getOwner()).getReturnType()), constructorTypeArguments);
        IrMemberAccessExpression<?> $this$createKProperty_u24lambda_u2420_u24lambda_u2419 = irMemberAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createKProperty_u24lambda_u2420, (IrFunctionSymbol)symbol2, (IrType)initializerType, constructorTypeArguments);
        boolean bl14 = false;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createKProperty_u24lambda_u2420;
        String string2 = ((IrProperty)((IrPropertySymbol)expression2.getSymbol()).getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "expression.symbol.owner.name.asString()");
        $this$createKProperty_u24lambda_u2420_u24lambda_u2419.putValueArgument(0, ExpressionHelpersKt.irString(irBuilderWithScope, string2));
        KTypeGeneratorInterface bl11 = kTypeGenerator;
        int n9 = 1;
        IrMemberAccessExpression<?> irMemberAccessExpression2 = $this$createKProperty_u24lambda_u2420_u24lambda_u2419;
        boolean bl15 = false;
        IrExpression irExpression3 = $this$createKProperty_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418.irKType((IrBuilderWithScope)$this$createKProperty_u24lambda_u2420, (IrType)returnType2);
        irMemberAccessExpression2.putValueArgument(n9, irExpression3);
        if (getterCallableReference != null) {
            $this$createKProperty_u24lambda_u2420_u24lambda_u2419.putValueArgument(2, (IrExpression)getterCallableReference);
        }
        if (setterCallableReference != null) {
            $this$createKProperty_u24lambda_u2420_u24lambda_u2419.putValueArgument(3, (IrExpression)setterCallableReference);
        }
        IrMemberAccessExpression<?> initializer2 = irMemberAccessExpression;
        $this$createKProperty_u24lambda_u2420.unaryPlus(initializer2);
        return this_$iv$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression createLocalKProperty(String propertyName, IrType propertyType, KTypeGeneratorInterface kTypeGenerator, IrBuilderWithScope irBuilder) {
        void $this$createLocalKProperty_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421;
        IrMemberAccessExpression<?> irMemberAccessExpression;
        IrBuilderWithScope $this$createLocalKProperty_u24lambda_u2423 = irBuilder;
        boolean bl = false;
        Pair<IrConstructorSymbol, List<IrType>> pair = this.getKPropertyImplConstructor(CollectionsKt.emptyList(), propertyType, true, false);
        IrConstructorSymbol symbol2 = pair.component1();
        List<IrType> constructorTypeArguments = pair.component2();
        IrSimpleType initializerType = IrTypesKt.typeWith(IrTypesKt.getClassifierOrFail(((IrConstructor)symbol2.getOwner()).getReturnType()), constructorTypeArguments);
        IrMemberAccessExpression<?> $this$createLocalKProperty_u24lambda_u2423_u24lambda_u2422 = irMemberAccessExpression = ExpressionHelpersKt.irCall($this$createLocalKProperty_u24lambda_u2423, (IrFunctionSymbol)symbol2, (IrType)initializerType, constructorTypeArguments);
        boolean bl2 = false;
        $this$createLocalKProperty_u24lambda_u2423_u24lambda_u2422.putValueArgument(0, ExpressionHelpersKt.irString($this$createLocalKProperty_u24lambda_u2423, propertyName));
        KTypeGeneratorInterface kTypeGeneratorInterface = kTypeGenerator;
        int n = 1;
        IrMemberAccessExpression<?> irMemberAccessExpression2 = $this$createLocalKProperty_u24lambda_u2423_u24lambda_u2422;
        boolean bl3 = false;
        IrExpression irExpression = $this$createLocalKProperty_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421.irKType($this$createLocalKProperty_u24lambda_u2423, propertyType);
        irMemberAccessExpression2.putValueArgument(n, irExpression);
        IrMemberAccessExpression<?> initializer2 = irMemberAccessExpression;
        return initializer2;
    }

    private final boolean isKMutablePropertyType(IrType type2) {
        IrClassSymbol irClassSymbol;
        if (!(type2 instanceof IrSimpleType)) {
            return false;
        }
        switch (((IrSimpleType)type2).getArguments().size()) {
            case 0: {
                return false;
            }
            case 1: {
                irClassSymbol = this.symbols.getKMutableProperty0();
                break;
            }
            case 2: {
                irClassSymbol = this.symbols.getKMutableProperty1();
                break;
            }
            case 3: {
                irClassSymbol = this.symbols.getKMutableProperty2();
                break;
            }
            default: {
                throw new IllegalStateException("More than 2 receivers is not allowed".toString());
            }
        }
        IrClassSymbol expectedClass = irClassSymbol;
        return Intrinsics.areEqual(((IrSimpleType)type2).getClassifier(), expectedClass);
    }

    private static final IrExpression createKTypeGenerator$lambda$0(WasmPropertyReferenceLowering this$0, IrBuilderWithScope $receiver, IrType it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($receiver, "$receiver");
        Intrinsics.checkNotNullParameter(it, "it");
        return ExpressionHelpersKt.irCall($receiver, this$0.symbols.getKTypeStub());
    }

    public static final /* synthetic */ IrExpression access$createKProperty(WasmPropertyReferenceLowering $this, IrPropertyReference expression2, KTypeGeneratorInterface kTypeGenerator, IrBuilderWithScope irBuilder) {
        return $this.createKProperty(expression2, kTypeGenerator, irBuilder);
    }

    public static final /* synthetic */ IrExpression access$createLocalKProperty(WasmPropertyReferenceLowering $this, String propertyName, IrType propertyType, KTypeGeneratorInterface kTypeGenerator, IrBuilderWithScope irBuilder) {
        return $this.createLocalKProperty(propertyName, propertyType, kTypeGenerator, irBuilder);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmPropertyReferenceLowering$KTypeGeneratorInterface;", "", "irKType", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "backend.wasm"})
    public static interface KTypeGeneratorInterface {
        @NotNull
        public IrExpression irKType(@NotNull IrBuilderWithScope var1, @NotNull IrType var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmPropertyReferenceLowering$DECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.wasm"})
    private static final class DECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION
    extends IrDeclarationOriginImpl {
        @NotNull
        public static final DECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION INSTANCE = new DECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION();

        private DECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION() {
            super("KPROPERTIES_FOR_DELEGATION", false, 2, null);
        }
    }
}

