/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.agent;

import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.kafka.trogdor.agent.Agent;
import org.apache.kafka.trogdor.rest.AgentStatusResponse;
import org.apache.kafka.trogdor.rest.CreateWorkerRequest;
import org.apache.kafka.trogdor.rest.CreateWorkerResponse;
import org.apache.kafka.trogdor.rest.Empty;
import org.apache.kafka.trogdor.rest.StopWorkerRequest;
import org.apache.kafka.trogdor.rest.StopWorkerResponse;

@Path(value="/agent")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AgentRestResource {
    private final AtomicReference<Agent> agent = new AtomicReference<Object>(null);
    @Context
    private ServletContext context;

    public void setAgent(Agent myAgent) {
        this.agent.set(myAgent);
    }

    @GET
    @Path(value="/status")
    public AgentStatusResponse getStatus() throws Throwable {
        return this.agent().status();
    }

    @POST
    @Path(value="/worker/create")
    public CreateWorkerResponse createWorker(CreateWorkerRequest req) throws Throwable {
        return this.agent().createWorker(req);
    }

    @PUT
    @Path(value="/worker/stop")
    public StopWorkerResponse stopWorker(StopWorkerRequest req) throws Throwable {
        return this.agent().stopWorker(req);
    }

    @PUT
    @Path(value="/shutdown")
    public Empty shutdown() throws Throwable {
        this.agent().beginShutdown();
        return Empty.INSTANCE;
    }

    private Agent agent() {
        Agent myAgent = this.agent.get();
        if (myAgent == null) {
            throw new RuntimeException("AgentRestResource has not been initialized yet.");
        }
        return myAgent;
    }
}

