/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.server;

import com.google.gwt.i18n.client.Constants;
import com.google.gwt.i18n.client.LocalizableResource;
import com.google.gwt.i18n.client.Messages;
import com.google.gwt.i18n.server.KeyGenerator;
import com.google.gwt.i18n.server.KeyGeneratorAdapter;
import com.google.gwt.i18n.server.Message;
import com.google.gwt.i18n.server.keygen.MethodNameKeyGenerator;

public class MessageUtils {
    public static Class<?>[] SELECTOR_ANOTATIONS = new Class[]{Messages.PluralCount.class, Messages.Select.class};

    public static String getConstantsDefaultValue(Message msg) {
        Constants.DefaultStringValue dsv = msg.getAnnotation(Constants.DefaultStringValue.class);
        if (dsv != null) {
            return dsv.value();
        }
        Constants.DefaultIntValue div = msg.getAnnotation(Constants.DefaultIntValue.class);
        if (div != null) {
            return String.valueOf(div.value());
        }
        Constants.DefaultBooleanValue dbv = msg.getAnnotation(Constants.DefaultBooleanValue.class);
        if (dbv != null) {
            return String.valueOf(dbv.value());
        }
        Constants.DefaultDoubleValue ddv = msg.getAnnotation(Constants.DefaultDoubleValue.class);
        if (ddv != null) {
            return String.valueOf(ddv.value());
        }
        Constants.DefaultFloatValue dfv = msg.getAnnotation(Constants.DefaultFloatValue.class);
        if (dfv != null) {
            return String.valueOf(dfv.value());
        }
        Constants.DefaultStringArrayValue dsav = msg.getAnnotation(Constants.DefaultStringArrayValue.class);
        if (dsav != null) {
            StringBuilder buf = new StringBuilder();
            boolean needComma = false;
            for (String value : dsav.value()) {
                if (needComma) {
                    buf.append(',');
                } else {
                    needComma = true;
                }
                buf.append(MessageUtils.quoteComma(value));
            }
            return buf.toString();
        }
        Constants.DefaultStringMapValue dsmv = msg.getAnnotation(Constants.DefaultStringMapValue.class);
        if (dsmv != null) {
            String[] values = dsmv.value();
            StringBuilder buf = new StringBuilder();
            boolean needComma = false;
            for (int i = 0; i < values.length; i += 2) {
                if (needComma) {
                    buf.append(',');
                } else {
                    needComma = true;
                }
                buf.append(MessageUtils.quoteComma(values[i]));
            }
            return buf.toString();
        }
        return null;
    }

    public static KeyGenerator getKeyGenerator(LocalizableResource.GenerateKeys keyGenAnnot) throws KeyGeneratorException {
        if (keyGenAnnot == null) {
            return new MethodNameKeyGenerator();
        }
        String keyGenClassName = keyGenAnnot.value();
        ReflectiveOperationException caught = null;
        try {
            Class<?> clazz = Class.forName(keyGenClassName);
            if (KeyGenerator.class.isAssignableFrom(clazz)) {
                Class<KeyGenerator> kgClass = clazz.asSubclass(KeyGenerator.class);
                return kgClass.newInstance();
            }
            if (com.google.gwt.i18n.rebind.keygen.KeyGenerator.class.isAssignableFrom(clazz)) {
                Class<com.google.gwt.i18n.rebind.keygen.KeyGenerator> kgClass = clazz.asSubclass(com.google.gwt.i18n.rebind.keygen.KeyGenerator.class);
                return new KeyGeneratorAdapter(kgClass.newInstance());
            }
            throw new KeyGeneratorException(keyGenClassName + " in @GenerateKeys must implement KeyGenerator");
        }
        catch (ClassNotFoundException e) {
            caught = e;
        }
        catch (InstantiationException e) {
            caught = e;
        }
        catch (IllegalAccessException e) {
            caught = e;
        }
        throw new KeyGeneratorException("Unable to process @GenerateKeys('" + keyGenClassName + "'): " + caught.getMessage(), caught);
    }

    public static String quoteComma(String value) {
        return value.replace(",", "\\,");
    }

    public static class KeyGeneratorException
    extends Exception {
        public KeyGeneratorException(String message) {
            super(message);
        }

        public KeyGeneratorException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

